# Review Article

# Quantum Many-Body Scars and Hilbert Space Fragmentation: A Review of Exact Results

Sanjay Moudgalya, $^ { 1 , 2 }$ B. Andrei Bernevig $^ { 3 , 4 , 5 }$ and Nicolas Regnault3,6

$\bot$ Institute for Quantum Information and Matter, California Institute of Technology,   
Pasadena, CA 91125, USA   
2 Walter Burke Institute for Theoretical Physics, California Institute of Technology,   
Pasadena, California 91125, USA   
$^ { 3 }$ Department of Physics, Princeton University, Princeton, NJ 08544, USA   
$^ 4$ Donostia International Physics Center, P. Manuel de Lardizabal 4, 20018   
Donostia-San Sebastian, Spain   
$^ 5$ IKERBASQUE, Basque Foundation for Science, Bilbao, Spain   
$^ 6$ Laboratoire de Physique de l’Ecole normale sup´erieure, ENS, Universit´e PSL,   
CNRS, Sorbonne Universit´e, Universit´e Paris-Diderot, Sorbonne Paris Cit´e, 75005   
Paris, France

Abstract. The discovery of Quantum Many-Body Scars (QMBS) both in Rydberg atom simulators and in the Affleck-Kennedy-Lieb-Tasaki (AKLT) spin-1 chain model, have shown that a weak violation of ergodicity can still lead to rich experimental and theoretical physics. In this review, we provide a pedagogical introduction to and an overview of the exact results on weak ergodicity breaking via QMBS in isolated quantum systems with the help of simple examples such as the fermionic Hubbard model. We also discuss various mechanisms and unifying formalisms that have been proposed to encompass the plethora of systems exhibiting QMBS. We cover examples of equally-spaced towers that lead to exact revivals for particular initial states, as well as isolated examples of QMBS. Finally, we review Hilbert Space Fragmentation, a related phenomenon where systems exhibit a richer variety of ergodic and non-ergodic behaviors, and discuss its connections to QMBS.

# Contents

1 Introduction

# 2 Ergodicity in Isolated Quantum Systems 5

2.1 Eigenstate Thermalization Hypothesis (ETH) 6   
2.2 Level Statistics 8   
2.3 Entanglement . 8   
2.4 Ergodicity Breaking . 10   
2.4.1 Integrability . . 11   
2.4.2 Many-Body Localization . . 11   
2.4.3 Quantum Many-Body Scars (QMBS) 11   
2.4.4 Hilbert Space Fragmentation . 12

# 3 Towers of QMBS 12

# 3.1 Simple examples: Spectrum Generating Algebras . . . . 13

3.1.1 Hubbard model 14   
3.1.2 Ferromagnetic Towers 16   
3.1.3 Spin-1 XY Model 17   
3.2 Survey of other towers in the literature 18   
3.2.1 AKLT Model 18   
3.2.2 General Structure of QMBS Towers 19   
3.2.3 Miscellaneous Examples 20   
3.3 Entanglement of quasiparticle towers of states 21   
3.4 Revivals from simple initial states 23

# 4 Unified Formalisms 25

4.1 Shiraishi-Mori embedding formalism . . . . 25

4.2 SGA-based formalism . . . . 26   
4.2.1 MLM Framework . 26   
4.2.2 RSGA formalism 27   
4.3 Symmetry-based formalisms 27   
4.3.1 Quasisymmetry and Tunnels to Towers Formalisms 27   
4.3.2 Group Invariant Formalism 30

# 5 Isolated QMBS 31

# 5.1 Survey of isolated QMBS . . . . . . . 31

5.2 PXP models . 32   
5.2.1 Model and Approximate QMBS 33   
5.2.2 Exact QMBS in 1d 33   
5.2.3 Exact QMBS in Higher Dimensions 34   
5.3 Other exact eigenstates . . 34

# 6 Hilbert Space Fragmentation and Krylov Subspaces 35

6.1 Simple example: Pair-hopping model . . . 36

6.1.1 Model and symmetries 36   
6.1.2 Frozen configurations and small Krylov subspaces 37   
6.1.3 Exponentially large Krylov subspaces 37   
6.1.4 Krylov subspaces due to blockades 38   
6.1.5 Strong v/s weak fragmentation 38   
6.2 Survey of other examples in the literature 39   
6.2.1 Spin-1 Dipole Conserving Model . 39   
6.2.2 $t - J _ { z }$ Model 39   
6.2.3 Miscellaneous Examples 40   
6.2.4 Higher Dimensional Systems . . 40   
6.2.5 General features of fragmented systems 41   
6.3 Implications to dynamics and connections to QMBS 41   
6.3.1 Strong Fragmentation 41   
6.3.2 Weak fragmentation 43   
6.3.3 Krylov-Restricted Thermalization . . 43   
6.3.4 Labelling Krylov Subspaces 44   
6.4 Autocorrelation Functions 45   
6.4.1 Definition and Properties . . . 46   
6.4.2 Strong Fragmentation 46   
6.4.3 Weak fragmentation 47

# 7 Discussion and Outlook

# 1. Introduction

The advent of quantum simulators, implemented for example in ultracold atomic setups or superconducting circuits, has put at the forefront the question of out-of-equilibrium quantum many-body systems. The Eigenstate Thermalization Hypothesis (ETH) [1, 2] has long been thought to describe the properties of all finite-energy density eigenstates, i.e., excited states in the middle of the energy spectrum, of any generic non-integrable quantum many-body system. ETH has been tested experimentally, analytically and numerically in various systems (however, mostly in one dimension), and it forms the pillar of our understanding of phenomena such as many-body quantum chaos and thermalization.

While the formulation of ETH sounds general, it is nevertheless a hypothesis, and thus immediately raises the question of potential counter-examples. Among them, quantum integrable models are the simplest cases where violations of ETH are known. Such systems exhibit an extensive number of conserved quantities that in principle determine every eigenstate in the system, which exhibit features that might strongly deviate from a typical thermal eigenstates. While non-interacting integrable models such as free fermion models are ubiquitous in physics, interacting ones are usually considered as fine-tuned and are harder to experimentally implement. The search for more generic violations of ETH beyond integrable systems began with the discovery of many-body localization (MBL), where the alliance of strong disorder and interaction leads to emergent integrability (see for example the two review articles Refs. [3] and [4]), although the existence and stability of MBL is currently being debated [5, 6].

The intermediate situation, a weak or partial violation of ETH by a small number (exponentially smaller than the Hilbert space dimension) of eigenstates, might be considered at first sight as too non-generic to be interesting or experimentally relevant. Indeed, any such non-thermal eigenstate would not have an energy gap protecting its nature, and would be exponentially close in energy to thermal eigenstates that would quickly hybridize with it under small perturbations. However, an experimental observation of anomalously long-lived revivals in a Rydberg atom quantum simulator [7] showed the opposite; the revivals were attributed to a small set of nonthermal eigenstates, dubbed Quantum Many-Body Scars (QMBS), in the otherwise non-integrable PXP model that captured the experiment [8, 9]. These results on Rydberg atoms also led to numerous further theoretical investigations of the PXP model [10, 11, 12], aspects of which have been summarized in the recent review Ref. [13] (see Ref. [14] for a longer version). The typical spectrum of a system exhibiting QMBS is depicted in Fig. 1a: a discrete number of non-ETH eigenstates that “scar” the spectrum of an apparently ergodic system. With a proper choice of an experimentally motivated initial state, the time-evolution of the quantum many-body system would then show a strong departure from the typical behavior of thermal non-integrable models.

In parallel to this experimental breakthrough, QMBS were independently discovered using a purely theoretical approach in a different context. Ref. [15] derived in the Affleck-Kennedy-Lieb-Tasaki (AKLT) spin-1 model [16] a series of energetically equallyspaced exact excited eigenstates, i.e., a tower of states, that provably violates ETH in an otherwise non-integrable model. This led to a flurry of analytical results that provided a complementary perspective on QMBS and attempted to establish a rigorous understanding of its emergence based on either brute force analytical derivation of excited states, or an underlying algebraic structure or symmetry. This should be put in contrast with some other forms of ergodicity breaking, e.g., MBL, where analytical progress has been hindered by the scarcity of exact results. Beyond the AKLT model, QMBS have been found in a variety of systems, sometime giving the opportunity to revisit some of the most celebrated condensed-matter interacting models such as the Hubbard model, in the search for analytical expression of exact excited states. QMBS are also closely related to the broader phenomenon of Hilbert space fragmentation [17] (also referred to as Hilbert space shattering [18], Krylov fracture [19], or jamming [20]), which refers to the existence of exponentially many dynamically disconnected subspaces that are not captured by conventional symmetries. There, a physically motivated basis choice unveils a rich structure within the Hamiltonian of dynamically disconnected subspaces with different thermalization and entanglement properties, as sketched in Fig. 1b. Akin to QMBS, analytically tractable models offer an invaluable playground to understand the nature of Hilbert space fragmentation and their effects on dynamics.

In this review, we focus on exact analytical results about QMBS which already provide a wealth of interesting models, analytical derivations and formalisms. We refer the readers leaning towards direct experimental implications of QMBS or in the approximate QMBS of PXP and related models to Ref. [13]. The review is organized as follows. In Sec. 2, we provide, for pedagogical purposes, a short overview on ergodicity and its breakdown in isolated quantum systems, introducing notations and concepts used in QMBS literature. Sec. 3 focuses on towers of QMBS and explicitly illustrates the towers derived from the spectrum generating algebra or dynamical symmetry in the fermionic Hubbard model. We also survey other examples of towers of QMBS in the literature, discuss their entanglement properties, and demonstrate how they lead to revivals from simple initial states. Sec. 4 gives an overview of the different known mechanisms inducing towers of QMBS, namely the eigenstate embedding, the spectrum generating algebra and their generalizations, and the symmetry-based formalisms. We dedicate Sec. 5 to reviewing several examples of isolated QMBS, due to its connection to some exact results in the PXP model, as well as a highly general formalism for embedding exact QMBS into the spectrum of any non-integrable Hamiltonian. In Sec. 6 we review ergodicity breaking via the broader phenomenon of Hilbert space fragmentation, exemplified through dipole-conserving systems, and discuss their dynamical implications and connections to QMBS. Finally we discuss some major questions still open in the field in Sec. 7.

![](images/03bcf6ad800fab556040d744fc56e9fe850fee41baf5ee97a22131bf51ac452c.jpg)  
Figure 1. (Color online) Two types of ergodicity breaking that we study in this review. (a) Quantum Many-Body Scars (QMBS): typical example of an energy spectrum with solvable ETH-violating eigenstates that show sub-volume law entanglement and exist amidst a sea of ETH-satisfying states that show volume-law entanglement. States close to the edges of the spectrum such as the ground state (GS) or low-energy excitations (GS-like) show area-law entanglement and are not expected to satisfy ETH. (b) Hilbert Space Fragmentation: Hamiltonian matrix represented consists of several dynamically disconnected Krylov subspaces, i.e. it is block-diagonal in a certain simple basis (e.g., the product state basis). The size of the Krylov subspaces can grow with system size or stay finite-dimensional, and the Hamiltonian restricted to the Krylov subspaces can be integrable (green) or non-integrable (red). The Hamiltonian in non-integrable Krylov subspaces is expected to satisfy Krylov-Restricted ETH.

# 2. Ergodicity in Isolated Quantum Systems

We begin by reviewing aspects of dynamics of isolated quantum systems. For the sake of concreteness, we focus on a system with $L$ spins and Hamiltonian $H$ . We are typically interested in the dynamics of a simple wavefunction $| \psi ( 0 ) \rangle$ under the Hamiltonian $H$ , where simple wavefunctions are those that are experimentally accessible, for example, product states or ground states of simple local Hamiltonians. The system evolves the state unitarily, and the wavefunction of the full system at time $t$ is given by $| \psi ( t ) \rangle = e ^ { - i H t } | \psi ( 0 ) \rangle$ . An isolated quantum system without any other symmetries is said to be ergodic or thermal if the reduced density matrix of any small subsystem $\mathcal { A }$ of $L _ { A } \ll L$ spins, defined as $\rho _ { \mathcal { A } } ( t ) \equiv \mathrm { T r } _ { \mathcal { B } } \left( | \psi ( t ) \rangle \langle \psi ( t ) | \right)$ evolves to a Gibbs density matrix.

$$
\operatorname* { l i m } _ { t  \infty } \rho _ { \cal A } ( t ) = \mathrm { T r } _ { \cal B } ( \rho ^ { e q } ) \approx \rho _ { \cal A } ^ { e q } , \rho ^ { e q } = \frac { 1 } { Z } e ^ { - \beta H }
$$

where $Z$ is the partition function for the subsystem, $\beta$ is an inverse-temperature associated with the initial state. In particular, Eq. (1) implies that the rest of the system acts as a thermal bath for the small subsystem $\mathcal { A }$ [3], and as a consequence, the late-time expectation values of (sums of) local operators $\hat { O }$ that are supported on a small number of sites should match their thermal expectation values. In the presence of additional symmetries, Eq. (1) is suitably modified to include a grand canonical ensemble formed by the symmetries, and we refer the readers to detailed reviews on this subject in Refs. [21, 22]. These conditions on the dynamics of states have a direct implication on the structure of eigenstates of the system, which we now discuss.

# 2.1. Eigenstate Thermalization Hypothesis (ETH)

The definition of thermalization in Eq. (1) naturally leaves open the question of which initial states $| \psi ( 0 ) \rangle$ thermalize. Informally speaking, if any initial state at some energy density of a system thermalizes under a Hamiltonian $H$ , the eigenstates of $H$ at that energy density should also thermalize. Since we expect such initial state behavior generically, we arrive at the Eigenstate Thermalization Hypothesis (ETH), which loosely states that any eigenstate of the Hamiltonian at a finite energy density is thermal. That is, the reduced density matrix of an eigenstate with energy $E _ { \alpha }$ over a small subsystem $\mathcal { A }$ should also be the Gibbs density matrix over the subsystem with an inverse-temperature $\beta _ { \alpha }$ that depends on $E _ { \alpha }$ . Indeed, we expect $\beta _ { \alpha } \to \infty$ when $E _ { \alpha }$ is close to the ground state energy, and $\beta _ { \alpha } \to 0$ when $E _ { \alpha }$ corresponds to the middle of the spectrum. A more accurate form of ETH is motivated in terms of expectation values of local operators as follows. For a system of volume $V$ and a local Hamiltonian $H$ , typical initial product states $| \psi ( 0 ) \rangle$ have energy variances $\Delta \sim \sqrt { V }$ , which, in the thermodynamic limit, is much smaller than the energy bandwidth $W$ which scales as $\sim V$ , i.e. [23]

$$
\left. \psi ( 0 ) \right| H \left| \psi ( 0 ) \right. = \bar { E } , \sqrt { \left. \psi ( 0 ) \right| H ^ { 2 } \left| \psi ( 0 ) \right. - \bar { E } ^ { 2 } } = \Delta \ll W .
$$

Hence, when any product state is expressed in the energy eigenbasis $\{ | E _ { \alpha } \rangle \}$ of a local Hamiltonian $H$ as |ψ(0)i = Pcα |Eαi, the magnitudes of the coefficients $\{ | c _ { \alpha } | ^ { 2 } \}$ turn out to be significant only in an energy window $E _ { \alpha } \in [ E - \Delta , E + \Delta ]$ . The expectation

value of a local operator $\widehat { O }$ as a function of time then reads

$$
\langle \widehat { O } ( t ) \rangle \equiv \langle \psi ( t ) | \widehat { O } | \psi ( t ) \rangle = \sum _ { \alpha } | c _ { \alpha } | ^ { 2 } O _ { \alpha \alpha } + \sum _ { \alpha \neq \beta } c _ { \alpha } ^ { * } c _ { \beta } O _ { \alpha \beta } e ^ { i ( E _ { \alpha } - E _ { \beta } ) t } ,
$$

where ${ \cal O } _ { \alpha \beta } = \langle E _ { \alpha } | \widehat { \cal O } | E _ { \beta } \rangle$ . Assuming there are no degeneracies in the spectrum, the time-averaged expectation value cancels the off-diagonal terms in Eq. (3), the long-time average is determined only by the average in the “diagonal ensemble”:

$$
\operatorname* { l i m } _ { T \to \infty } \frac { 1 } { T } \int _ { 0 } ^ { T } d t \ \langle \widehat { O } ( t ) \rangle = \sum _ { \alpha } \lvert c _ { \alpha } \rvert ^ { 2 } O _ { \alpha \alpha } .
$$

In a thermalizing system, we expect the long-time average to be equal to the expectation value of a local operator in a microcanonical ensemble around energy $E$ of the initial state, requiring

$$
\sum _ { E _ { \alpha } \in \left[ \bar { E } - \Delta , \bar { E } + \Delta \right] } O _ { \alpha \alpha } = \sum _ { \alpha } \lvert c _ { \alpha } \rvert ^ { 2 } O _ { \alpha \alpha } .
$$

Using the fact that magnitudes $| c _ { \alpha } | ^ { 2 }$ are significant only in the energy window $[ \bar { E } - \Delta , \bar { E } + \Delta ]$ , Eq. (5) suggests that $O _ { \alpha \alpha }$ on the RHS is only a function of the energy $E$ rather than the eigenstate energy $E _ { \alpha }$ . These arguments, along with many other motivations [2], led to a formal conjecture on the matrix elements of local operators in the energy eigenstates of a non-integrable model take the form [22]

$$
\left. E _ { m } \right. \widehat { O } \left. E _ { n } \right. = \bar { O } \left( E \right) \delta _ { m , n } + R _ { m , n } \Omega ( E ) ^ { - 1 / 2 } f _ { O } \left( E , \omega \right) ,
$$

where $\widehat { O }$ is a local operator, $E = \left( E _ { m } + E _ { n } \right) / 2$ , $\omega = E _ { m } - E _ { n } ^ { \prime }$ , $R _ { m , n }$ is a pseudorandom variable such that the distribution of $\{ R _ { m , n } \}$ (over all values of $m$ and $n$ ) has zero mean and unit variance, $\bar { O } \left( E \right)$ is a smooth function of $E$ and represents the thermal expectation value of $\widehat { O }$ at energy $E$ , $f _ { O } \left( E , \omega \right)$ is a smooth function of $E$ and $\omega$ which do not scale with the system size [22], and $\Omega \left( E \right)$ is the density of states at energy $E$ . Note that the thermal value is typically determined in practice by computing the microcanonical average, i.e. averaging the eigenstate expectation values $\langle E | \hat { O } | E \rangle$ over a small energy window $\Delta$ that corresponds to the Thouless energy scale [24]. In Eq. (6), for a system with Hilbert space dimension $\mathcal { D }$ , we expect $\Omega ( E ) \sim 1 / \mathcal { D }$ for states in the middle of the spectrum. Hence, the standard deviation of expectation values of operators in the eigenstates in the middle of the spectrum within the Thouless energy window $\Delta$ is expected to scale as $\sim 1 / \sqrt { \mathcal { D } }$ , which forms a standard numerical diagnostic of ETH [24] (although this scaling is debated [25]). We refer to Eq. (6) restricted to the cases $m = n$ and $m \neq n$ as diagonal ETH and off-diagonal ETH respectively [26]. In this review, we are primarily interested in the behavior of expectation values of local operators in eigenstates of the system, and hence in diagonal ETH. Note that for systems with additional symmetries such as particle number conservation, Eq. (6) is expected to hold for eigenstates within a particular quantum number sector [23, 22, 27].

The question of which initial states thermalize under time-evolution leads to two notions of diagonal ETH: strong ETH and weak ETH. Strong ETH states that all eigenstates obey diagonal ETH as stated in Eq. (6), which implies that all initial states thermalize. Evidence for the validity of strong ETH in typical non-integrable models has been found in Refs. [28, 29]. On the other hand, weak ETH states that almost all eigenstates obey diagonal ETH. In particular, this implies that there could be a small set (of fraction going to zero with increasing system size) of eigenstates violating diagonal ETH. Such a scenario can in principle lead to the non-thermalization of a few special initial states amidst the thermalization of most initial states. We will discuss this scenario in more detail in Sec. 2.4.

# 2.2. Level Statistics

Ergodicity in isolated quantum systems is typically considered synonymous with quantum chaos, a widely studied subject [30]. A system is said to be quantum chaotic if its correlation functions under time-evolution by the Hamiltonian at late times resembles correlations under time-evolution by a Random Matrix with the same symmetries. These considerations lead to defining features of quantum chaotic systems, such as the repulsion of nearest-neighbor eigenvalues [31] and the linear ramp in the Spectral Form Factor (SFF) of such systems [32]. Random Matrix Theory also provides remarkably accurate predictions of these quantities, and in particular for the statistics of nearest-neighboring energy differences $s _ { n } = ( E _ { n + 1 } - E _ { n } ) / \bar { E }$ , where $E _ { n }$ ’s are the sorted energy levels and $E$ is the mean energy level spacing in the vicinity of $E _ { n }$ [33]. It has been numerically verified for several non-integrable models that $s _ { n }$ follows a Wigner-Dyson distribution [34, 23, 3] whereas $s _ { n }$ in systems with several symmetries (e.g. integrable systems) follows a Poisson distribution [35]. This distribution can also be directly detected using the mean level spacing ratio $\langle r \rangle$ , which is the average of $r _ { n } = \mathrm { m i n } ( s _ { n } , s _ { n + 1 } ) / \mathrm { m a x } ( s _ { n } , s _ { n + 1 } )$ [36, 37]. $\left. r \right. \approx 0 . 5 3$ and $\langle r \rangle \approx 0 . 6$ for Wigner-Dyson ensembles with and without time-reversal symmetry, and $\langle r \rangle \approx 0 . 3 8$ for the Poisson distribution. Note that for non-integrable Hamiltonians with a few additional symmetries (e.g. particle number), signatures of ergodicity and its breaking are expected to appear in the distribution of energy levels within a symmetry sector [23, 22, 27]. One common signature of the breakdown of ergodicity is hence the change in the distribution of level statistics after resolving known symmetries, as we will discuss in Sec. 2.4.

# 2.3. Entanglement

The concepts of entanglement and entropy (as one of its measure) are widely used in several contexts in physics [38, 39], and are also crucial in the study of quantum dynamics as well as QMBS. The entanglement of a wavefunction $| \psi \rangle$ is defined via its

![](images/415fa255fff9e8f7e5902d809d03aa578e1794a57a27e20934cbf320dc3382b0.jpg)  
Figure 2. (a) $d \times \chi \times \chi$ tensor representing an MPS. $d$ is the physical dimension and $\chi$ is the bond-dimension (b) Wavefunction $| \psi \rangle$ represented in MPS form, $b _ { A } ^ { l }$ and $b _ { A } ^ { r }$ are $\chi$ -dimensional boundary vectors. The entanglement entropy of an MPS state is bounded by $S \leq \log \chi$ .

Schmidt decomposition about a bipartition into regions $\mathcal { A }$ and $\boldsymbol { B }$ , given by

$$
\mathinner { | { \psi } \rangle } = \sum _ { \alpha = 1 } ^ { \chi } \lambda _ { \alpha } \mathinner { | { \psi _ { \alpha } } \rangle } _ { \mathcal { A } } \mathinner { | { \psi _ { \alpha } } \rangle } _ { \mathcal { B } } ,
$$

where $\{ | \psi _ { \alpha } \rangle _ { \mathcal { A } } \}$ and $\{ \vert \psi _ { \alpha } \rangle _ { B } \}$ are orthonormal sets of wavefunctions on the subsystems $\mathcal { A }$ and $B$ respectively, $\lambda _ { \alpha }$ ’s are non-negative real numbers, and $\chi$ is known as the Schmidt rank of the wavefunction. For a normalized state $| \psi \rangle$ , we always have $\sum _ { \alpha = 1 } ^ { \chi } \lambda _ { \alpha } ^ { 2 } = 1$ . The (von Neumann) Entanglement Entropy (EE) $S$ of the state $| \psi \rangle$ over this bipartition is defined as

$$
S \equiv - \sum _ { \alpha = 1 } ^ { \chi } \lambda _ { \alpha } ^ { 2 } \log \lambda _ { \alpha } ^ { 2 } = - \mathrm { T r } _ { \cal A } \left( \rho _ { \cal A } \log \rho _ { \cal A } \right)
$$

where $\rho _ { \mathcal { A } }$ is the reduced density matrix over subsystem $\mathcal { A }$ . Ground states of gapped quantum many-body systems are known to exhibit a so-called “area-law” scaling of the EE, where $S$ scales proportionally to the area of the subsystem $\mathcal { A }$ , which, in onedimension implies that $S$ is independent of the subsystem size. On the other hand, the EE in ground states of critical gapless systems typically exhibit logarithmic violations of the area-law, i.e., $S$ scales with the area times the logarithm of the volume of the subsystem $\mathcal { A }$ [40, 38].

For highly excited states of non-integrable models, ETH predicts a “volume law” scaling of $S$ i.e. it scales proportionally to the volume of the subsystem $\mathcal { A }$ . This is a direct consequence of the reduced density matrix discussed in Eq. (1). In fact, for states in the middle of the spectrum, $\beta = 0$ in Eq. (1), and thus their EE is typically observed to be close to $S _ { \mathrm { t h } }$ , the mean EE of states in the Hilbert space [41], also known as the Page entropy, which is close to the maximum possible entropy $S _ { \mathrm { m a x } }$ . For a one-dimensional system with $L$ spin- $\frac { 1 } { 2 }$ ’s and $L _ { \mathcal { A } } = L / 2$ spin- $\frac { 1 } { 2 }$ ’s in subsystem $\mathcal { A }$ , these values are known to be

$$
S _ { \mathrm { t h } } = \frac { L \log 2 - 1 } { 2 } , \quad S _ { \mathrm { m a x } } = \frac { L \log 2 } { 2 } .
$$

Note that when $L _ { \mathcal { A } } / L$ is kept constant, $S _ { \mathrm { t h } }$ and $S _ { \mathrm { m a x } }$ typically differ by an $L$ -independent constant that only depends on the fraction $L _ { \mathcal { A } } / L$ and the properties of (e.g., the constraints on) the full Hilbert space [41, 42]; hence eigenstates in the middle of the spectrum are almost always maximally entangled.

Entanglement also plays an important role in understanding the structure of QMBS eigenstates. For example, most of the QMBS eigenstates that we review have exact Matrix Product States (MPS) representations [43, 44, 45, 46]. An MPS wavefunction $| \psi \rangle$ (with open boundary conditions) can be written as

$$
| \psi \rangle = \sum _ { \{ m _ { 1 } m _ { 2 } \ldots m _ { L } \} } { [ b _ { A } ^ { l } } ^ { T } A ^ { [ m _ { 1 } ] } \ldots A ^ { [ m _ { L } ] } b _ { A } ^ { r } ] | m _ { 1 } \ldots \ldots m _ { L } \rangle ,
$$

where $| m _ { 1 } \ldots m _ { L } \rangle$ denotes the many-body basis states where $\{ m _ { j } \}$ can take $d$ values, the dimension of the local physical Hilbert space. $\{ A ^ { \lfloor m _ { j } \rfloor } \}$ ’s are $\chi \times \chi$ matrices, where $\chi$ is referred to the bond-dimension of the MPS, and $b _ { A } ^ { l }$ and $b _ { A } ^ { r }$ are $\chi$ -dimensional left and right boundary vectors that determine the boundary conditions for the wavefunction. Diagrammatically, $A$ can be visualized as a $d \times \chi \times \chi$ tensor as shown in Fig. 2a and the state $| \psi \rangle$ as contractions of these tensors shown in Fig. 2b. Note that although any state can have multiple MPS representations, there is a canonical form of the MPS which has bond dimension $\chi$ that is the same as the number of non-zero Schmidt values of the state in Eq. (8). The EE for an MPS wavefunction then satisfies the bound

$$
S \leq \log \chi .
$$

Hence the growth of the bond-dimension $\chi$ of an MPS representation of the state is sufficient to determine the scaling of EE with system-size. For example, it is well-known that area-law ground states of gapped systems in one dimension admit approximate/exact MPS representations of bond dimension $\chi$ that is system-size independent [47]. In Sec. 3, we will apply these results to QMBS eigenstates and obtain the scaling of their EEs.

# 2.4. Ergodicity Breaking

Most local interacting Hamiltonians are believed to be non-integrable and fully ergodic, i.e. their eigenstates obey strong ETH. Indeed, the spectrum of a generic local Hamiltonian exhibits level repulsion and Wigner-Dyson level statistics, signalling the presence of quantum chaos. Nevertheless, as discussed in Sec. 1, systems with various degrees of ergodicity breaking have been found. A complete breakdown of ergodicity, i.e. a breakdown of strong and weak ETH, is known in two types of systems: Integrable and Many-Body Localized (MBL). In addition, two types of partial breakdowns of ergodicity have been found, and the phenomena go by the names Quantum Many Body Scars (QMBS) and Hilbert space fragmentation. We now provide a brief overview these types of ergodicity breaking in isolated quantum systems, and a summary of their properties is provided in Table 1.

2.4.1. Integrability Integrability occurs in the presence of an extensive number of conserved quantities, which leads to the complete solvability of the energy spectrum, at least in principle. The simplest examples of integrable systems are non-interacting systems, where the many-body spectrum is completely determined by the single-particle spectrum. Interacting examples of integrable models include ones with commuting projector Hamiltonians, such as the toric code [48, 49], being a celebrated example, and Bethe ansatz solvable models such as the one-dimensional XXZ and the one-dimensional Hubbard models [50]. Quantum integrability is not stable under generic perturbations, and moreover no analogues of the Kolmogorov-Arnold-Moser (KAM) theorem for classical integrability, that establishes some degree of stability under perturbations, have been rigorously established for quantum systems. Hence it is believed that a high degree of fine-tuning is required in the space of all local Hamiltonians in order to see signatures of quantum integrability.

2.4.2. Many-Body Localization On the other hand, MBL, the generalization of Anderson localization to interacting systems, is believed to occur more generically in the presence of strong disorder or quasiperiodicity [3, 4], although its stability in the thermodynamic limit has been a subject of active debate [51, 5, 52, 53]. In both cases, the existence of an extensive number of conserved quantities can be constructed, which leads to the absence of level repulsion that is reflected in the Poisson level statistics shown by these Hamiltonians. From the point of view of entanglement, MBL systems possess eigenstates with area-law entanglement that are easy to identify [54]. On the other hand, quantum integrable systems mostly possess volume-law entangled eigenstates with a few exceptions [55, 56], and their eigenstates are hence harder to distinguish from thermal eigenstates [57, 58].

2.4.3. Quantum Many-Body Scars (QMBS) A distinct type of ergodicity breaking, termed as weak ergodicity breaking in Ref. [8] can occur in systems that violate strong ETH but still obey weak ETH. Such systems exhibit a few highly excited eigenstates that violate diagonal ETH, i.e. they possess atypical features compared to most other eigenstates at the same energy density. These ETH-violating eigenstates in the middle of the spectrum are referred to as Quantum Many-Body Scars (QMBS). The term originates from the analogy to quantum scars in single-particle systems such as a Bunimovich stadium [59] or quantum maps [60], where a small set of singleparticle eigenstates with anomalous wavefunctions distributed on rare classical periodic orbits co-exist with generic eigenstates with wavefunctions distributed uniformly. Such systems are said to violate the Quantum Unique Ergodicity (QUE) conjecture, which is, roughly speaking, the analogue of strong ETH for single-particle systems. Typically, the number of QMBS grows exponentially slower than the Hilbert space dimension (either polynomially in system size or exponentially with a smaller base), and they constitute a measure-zero set in the thermodynamic limit. Since most of the spectrum exhibits level repulsion, systems with QMBS show level repulsion on average, as well as many other standard signatures of quantum chaos. We might expect that signatures of QMBS buried in the middle of the spectrum would be hard to experimentally access. Nevertheless, systems in which QMBS appear as equally spaced towers in the spectrum are of particular interest since equal spacings result in perfect revivals from particular initial states, a phenomenon that has been observed in Rydberg atom experiments [7, 61]. We discuss systems with equally spaced towers of QMBS in Sec. 3 and associated unified formalisms in Sec. 4, and systems with isolated QMBS in Sec. 5.

Table 1. Taxonomy of Ergodicity and various types of its breaking in Isolated Quantum Systems. They can be distinguished based on whether they satisfy strong/weak ETH, the entanglement entropy scaling of typical eigenstates in the middle of the spectrum, and their energy level statistics.   

<html><body><table><tr><td></td><td>Strong/Weak ETH</td><td>Entanglement</td><td>Level Statistics</td></tr><tr><td>Ergodic</td><td>Yes/Yes</td><td>Volume</td><td>Wigner-Dyson</td></tr><tr><td>Integrable</td><td>No/No</td><td>Volume/Sub-Volume</td><td>Poisson</td></tr><tr><td>MBL</td><td>No/No</td><td>Area</td><td>Poisson</td></tr><tr><td>Weakly ragmentdd</td><td>No/Yes</td><td>Volume/Sub-Volume</td><td>Wigner-Dyson</td></tr><tr><td> Strongly Fragmented</td><td>No/No</td><td>Volume/Sub-Volume</td><td>Poisson</td></tr></table></body></html>

2.4.4. Hilbert Space Fragmentation Another type of ergodicity breaking of a different origin can occur in constrained systems, where the Hilbert space splits into exponentially many dynamically disconnected parts, such that large parts of it are inaccessible to particular initial states. The term Hilbert space fragmentation was coined in Ref. [17] to refer to such systems. Fragmentation was divided into two main categories: weak and strong, depending on whether the fraction of states violating the conventional form of ETH are a set of measure zero or not in the thermodynamic limit. Weakly fragmented systems are also sometimes regarded as examples of QMBS [17, 18], since they obey weak ETH since the ETH-violating states form a set of measure-zero. However, strongly fragmented systems also violate conventional forms of weak ETH, and should be regarded as a distinct form of ergodicity breaking. Fragmented systems possess eigenstates that can show any scaling of EE from area-law to volume-law, depending on the size of the dynamically disconnected part of the Hilbert space they belong to. Moreover, as we discuss in more detail in Sec. 6, while weakly fragmented systems exhibit Wigner-Dyson level statistics, strongly fragmented systems typically consist of a large number of degeneracies in the spectrum, and can exhibit unconventional level statistics [35, 62].

# 3. Towers of QMBS

Since the ETH-violating eigenstates in quantum scarred systems constitute a measurezero set in the thermodynamic limit, it is natural to wonder whether they would influence the dynamics of any experimentally accessible initial states. As we discuss now, in cases where the spectrum includes an extensive number of non-thermal eigenstates in an equally spaced tower with energies $\{ E _ { 0 } , E _ { 0 } + \mathcal { E } , E _ { 0 } + 2 \mathcal { E } , \cdots , E _ { 0 } + ( N - 1 ) \mathcal { E } \}$ , novel dynamical phenomena are possible. For example, the presence of such a tower in the spectrum leads to perfect revivals in the systems under dynamics from particular initial states. Revivals can be probed by computing the fidelity $\mathcal { F } ( t )$ (also known as Loschmidt echo) of an initial state $| \psi ( 0 ) \rangle = \sum _ { n } c _ { n } \left| E _ { n } \right.$ , defined as

$$
\mathcal { F } ( t ) = | \left. \psi ( 0 ) | \psi ( t ) \right. | ^ { 2 } = | \sum _ { n } | c _ { n } | ^ { 2 } e ^ { - i E _ { n } t } | ^ { 2 } = \sum _ { m , n } | c _ { n } c _ { m } | ^ { 2 } e ^ { i ( E _ { m } - E _ { n } ) t } .
$$

For any initial state $| \psi ( 0 ) \rangle$ that lies completely within the subspace spanned by the tower of eigenstates, all of the energy differences $\{ E _ { m } - E _ { n } \}$ that appear in the sum of Eq. (12) are integer multiples of the spacing $\varepsilon$ , and hence the system exhibits perfect revivals with time-period of at most $\begin{array} { r } { T = \frac { 2 \pi } { \mathcal { E } } } \end{array}$ (i.e., $\mathcal F ( t { + } T ) = \mathcal F ( t ) .$ ). While this is obvious if $| \psi ( 0 ) \rangle$ is explicitly chosen to be a superposition of a few eigenstates $\{ | E _ { n } \rangle \}$ , it is not always clear that a product state or any physically relevant state can be constructed that way. Nevertheless, as we will discuss in Sec. 3.4, for models exhibiting QMBS, it is possible to construct states $| \psi ( 0 ) \rangle$ with area law entanglement that have overlap with an extensive number of eigenstates, and lie completely within the QMBS subspace. Conversely, it has been shown on general grounds [63] that the existence of perfect revivals from a low-entanglement and short-range correlated state implies the presence of equally-spaced (or commensurately-spaced) eigenstates in the middle of the spectrum having low entanglement entropy, i.e., towers of QMBS.

The first exact, i.e., analytical, example of such a tower of eigenstates was found in the integer spin AKLT models [15, 64], well-known in the context of ground state and low-energy physics [16, 65, 66]. Subsequently, numerous works found similar towers in simpler models such as the spin-1 XY model [67], and connections were established to the phenomenon of $\eta$ -pairing known in the context of Hubbard models [68]. In all these examples, the states in the tower are composed of multiple quasiparticles of a given energy and momentum dispersing on top of a fixed low-entanglement eigenstate such as the ground state. Several examples bear a direct resemblance to $\eta$ -pairing in Hubbard models, and we discuss them in Sec. 3.1. We survey other examples of towers of states, some that appear to have a more complicated origin such as the AKLT model, as well as other miscellaneous examples in Sec. 3.2.

# 3.1. Simple examples: Spectrum Generating Algebras

In the following, we discuss some simple examples of models that exhibit exact QMBS, based on structures referred to as Spectrum Generating Algebras (SGA). These examples form the foundation for systematic approaches to construct models with towers of exact QMBS. They capture several examples of towers that have been discussed in the literature, which we will present in Sec. 4.

3.1.1. Hubbard model For pedagogical purposes, we explicitly illustrate the towers of exact eigenstates in the celebrated Hubbard model, known as $\eta$ -pairing eigenstates [68, 69]. The Hamiltonian for the Hubbard model on a hypercubic lattice in $d$ -dimensions is given by

$$
H _ { \mathrm { H u b } } = \sum _ { \sigma \in \{ \uparrow , \downarrow \} } \left[ - \sum _ { \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle } t _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \left( c _ { \mathbf { r } , \sigma } ^ { \dagger } c _ { \mathbf { r } ^ { \prime } , \sigma } + h . c . \right) - \mu \sum _ { \mathbf { r } } \widehat { n } _ { \mathbf { r } , \sigma } \right] + U \sum _ { \mathbf { r } } \widehat { n } _ { \mathbf { r } , \uparrow } \widehat { n } _ { \mathbf { r } , \downarrow } ,
$$

where $\{ { \bf r } \}$ labels the sites of a lattice, $\langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle$ denotes neighboring sites, and $t _ { \mathbf { r } , \mathbf { r } ^ { \prime } }$ denotes the corresponding hopping strength, which is typically chosen to be site-independent. $c _ { \mathbf { r } , \sigma } ^ { \dagger }$ and $c _ { \mathbf { r } , \sigma }$ denote the fermion creation and annihilation operators on site $\mathbf { r }$ , and the on-site fermion number operator is defined as $\widehat { n } _ { { \bf r } , \sigma } \equiv c _ { { \bf r } , \sigma } ^ { \dagger } c _ { { \bf r } , \sigma }$ . The Hubbard model on any bipartite lattice has spin and pseudospin symmetries, which are examples of conventional and dynamical $S U ( 2 )$ symmetries respectively, as we discuss below. The spin $S U ( 2 )$ symmetry is composed of the operators $\{ S ^ { + } , S ^ { - } , S ^ { z } \}$ and the corresponding quadratic Casimir operator $\vec { S } ^ { 2 }$ , which are defined as

$$
\begin{array} { c }  { \displaystyle { S ^ { + } = \sum _ { \mathbf { r } } c _ { \mathbf { r } , \uparrow } ^ { \dagger } c _ { \mathbf { r } , \downarrow } , ~ S ^ { - } = ( S ^ { + } ) ^ { \dagger } , ~ S ^ { z } = \frac { 1 } { 2 } \sum _ { \mathbf { r } } ( \widehat { n } _ { \mathbf { r } , \uparrow } - \widehat { n } _ { \mathbf { r } , \downarrow } ) } } \\ { { \displaystyle { \vec { S } ^ { 2 } = \frac { 1 } { 2 } ( S ^ { + } S ^ { - } + S ^ { - } S ^ { + } ) + ( S ^ { z } ) ^ { 2 } . } } } \end{array}
$$

Similarly, the pseudospin $S U ( 2 )$ symmetry is composed of the operators $\{ \eta ^ { \dagger } , \eta , \eta ^ { z } \}$ and the corresponding quadratic Casimir $\vec { \eta } ^ { 2 }$ , which are defined on a bipartite hypercubic lattice with $L$ sites (and even number sites in directions with periodic boundary conditions) as

$$
\begin{array} { c } { \eta ^ { \dagger } = \displaystyle \sum _ { \bf r } e ^ { i \pi \cdot { \bf r } } c _ { { \bf r } , \uparrow } ^ { \dagger } c _ { { \bf r } , \downarrow } ^ { \dagger } , ~ \eta = ( \eta ^ { \dagger } ) ^ { \dagger } , ~ \eta ^ { z } = \displaystyle \frac { 1 } { 2 } \left( \displaystyle \sum _ { { \bf r } , \sigma } \hat { n } _ { { \bf r } , \sigma } - L \right) } \\ { \displaystyle \bar { \eta } ^ { 2 } \equiv \displaystyle \frac { 1 } { 2 } ( \eta ^ { \dagger } \eta + \eta \eta ^ { \dagger } ) + ( \eta ^ { z } ) ^ { 2 } . } \end{array}
$$

The spin and pseudospin are examples of $S U ( 2 )$ symmetries since they obey the usual $\mathfrak { s u } ( 2 )$ commutation relations

$$
[ S ^ { z } , S ^ { + } ] = S ^ { + } , ~ [ S ^ { z } , S ^ { - } ] = - S ^ { - } , ~ [ \eta ^ { z } , \eta ^ { \dagger } ] = \eta ^ { \dagger } , ~ [ \eta ^ { z } , \eta ] = - \eta .
$$

Further, they are symmetries of the Hubbard model of Eq. (13) on a bipartite lattice since they satisfy

$$
[ H _ { \mathrm { H u b } } , \eta ^ { z } ] = 0 , ~ [ H _ { \mathrm { H u b } } , \vec { \eta } ^ { 2 } ] = 0 , ~ [ H _ { \mathrm { H u b } } , S ^ { z } ] = 0 , ~ [ H _ { \mathrm { H u b } } , \vec { S } ^ { 2 } ] = 0 .
$$

As a consequence of Eq. (17), the eigenstates of the Hubbard model can be labelled by quantum numbers corresponding to two $S U ( 2 )$ symmetries – $( \vec { \eta } ^ { 2 } , \eta ^ { z } )$ and $( \vec { S } ^ { 2 } , S ^ { z } )$ , although these quantum numbers are not completely independent of each other [70].

A crucial difference between the two $S U ( 2 )$ symmetries lies in the commutation relation of $H _ { \mathrm { H u b } }$ with $\eta ^ { \dagger }$ and $S ^ { + }$ , which read

$$
[ H _ { \mathrm { H u b } } , S ^ { + } ] = 0 , \quad [ H _ { \mathrm { H u b } } , \eta ^ { \dagger } ] = ( U - 2 \mu ) \eta ^ { \dagger } .
$$

While the spin- $S U ( 2 )$ is an example of a conventional $S U ( 2 )$ symmetry, the latter is referred to as a Spectrum Generating Algebra (SGA) or a Dynamical Symmetry [71, 72, 73, 74], when for a Hamiltonian $H$ an operator $\eta ^ { \dagger }$ satisfies

$$
[ H , \eta ^ { \dagger } ] = \mathcal { E } \eta ^ { \dagger } .
$$

The conventional $S U ( 2 )$ symmetry is a special case of Eq. (19) where $\varepsilon = 0$ . While a conventional $S U ( 2 )$ symmetry results in the existence of degenerate multiplets of states in the spectrum (which are related by the action of raising and lowering operators $\eta ^ { \dagger }$ and $\eta$ ), an SGA with $\varepsilon \neq 0$ leads to the existence of a tower of equally spaced energy eigenstates, i.e. if $| \psi _ { 0 } \rangle$ is an eigenstate of $H$ with energy $E _ { 0 }$ , $\eta ^ { \dagger } \left| \psi _ { 0 } \right.$ is also an eigenstate with energy $E _ { 0 } + \mathcal { E }$ . Choosing $| \psi _ { 0 } \rangle$ to be an eigenstate of the Casimir operator $\vec { \eta } ^ { 2 }$ and $\eta ^ { z }$ with eigenvalues $J ( J + 1 )$ and $- J$ respectively for some $J$ , we obtain a multiplet of $( 2 J + 1 )$ eigenstates

$$
\left\{ \left. \psi _ { 0 } \right. , \eta ^ { \dagger } \left. \psi _ { 0 } \right. , \cdots , ( \eta ^ { \dagger } ) ^ { 2 J } \left. \psi _ { 0 } \right. \right\}
$$

with equally spaced energies given by

$$
\{ E _ { 0 } , E _ { 0 } + \mathcal { E } , E _ { 0 } + 2 \mathcal { E } , \cdot \cdot \cdot , E _ { 0 } + 2 J \mathcal { E } \} .
$$

Provided the state $| \psi _ { 0 } \rangle$ is a solvable eigenstate, Eq. (20) denotes an exact tower of eigenstates. A special set of solvable eigenstates of the Hubbard model are spin-polarized states that consist of only one type of spin $\uparrow$ or $\downarrow$ . The interaction term in Eq. (13) acts trivially on these states, which enables the construction of subspaces in which the action of the Hubbard model reduces to a quadratic Hamiltonian that can be solved exactly. The simplest example of a solvable state is the vacuum state $| \Omega \rangle$ with no particles, and it can be used to construct a simple exact tower of states of the form Eq. (20) [75]. For example, such a tower in one dimension has the following form

$$
\begin{array} { c } { { | \Omega \rangle = | 0 \ 0 \ \cdots \ 0 \ 0 \rangle , \eta ^ { \dagger } | \Omega \rangle = \displaystyle \sum _ { j } ( - 1 ) ^ { j } \ | 0 \ \cdots \ 0 \ \stackrel { j } { \downarrow } \ 0 \ \cdots \ 0 \rangle , } } \\ { { \displaystyle ( \eta ^ { \dagger } ) ^ { 2 } | \Omega \rangle = \displaystyle \sum _ { j , k } ( - 1 ) ^ { j + k } | 0 \cdot \cdot \cdot 0 \ \stackrel { j } { \uparrow } \ 0 \cdot \cdot \cdot 0 \ \stackrel { k } { \downarrow } \ 0 \cdot \cdot \cdot 0 \rangle , \ \cdots } } \\ { { \displaystyle \cdot \cdot \ \cdot , \ ( \eta ^ { \dagger } ) ^ { L } | \Omega \rangle = | \updownarrow \ \backslash \ \cdots \ \pm \frac { \chi } { \downarrow } \ \uparrow \rangle , } } \end{array}
$$

where 0 denotes an empty site, $\uparrow$ and $\downarrow$ denote sites with one of the two types of spins, and $\updownarrow$ denotes a doubly occupied site, which we refer to as a doublon. As evident from Eq. (22), the state $( \eta ^ { \dagger } ) ^ { n } \left| \Omega \right.$ consists of $n$ momentum $\pi$ doublon “quasiparticles” dispersing around the system, so that the full state has momentum $n \pi$ . As we will discuss later in Secs. 3.2 and 4, the quasiparticle nature of eigenstates is a general feature of towers of QMBS.

Several of the analytically tractable towers of states in the Hubbard model, including the ones of Eq. (22) do not exhibit a volume-law scaling of EE [75], owing to their quasiparticle nature. While some of these towers are also in the middle of the full many-body energy spectrum, to really qualify as examples of QMBS, they should be in the middle of the spectrum after resolving symmetries of the system [22, 27]. However, for the simplest tractable towers such as Eq. (22), it turns out that they are the only states within their quantum number sector after resolving the spin and pseudospin $S U ( 2 )$ symmetries of Eq. (17) [75], hence they are not considered as examples of QMBS in the Hubbard model.‡ Nevertheless, Refs. [76, 77] showed that local terms can be added to the Hubbard model that break either one of the two $S U ( 2 )$ symmetries and translation symmetry while preserving some of the analytically tractable towers as eigenstates. Such models are said to exhibit a Restricted Spectrum Generating Algebra (RSGA) [76], and we will discuss its precise statement in Sec. 4. The remaining towers of states in such models are generically in the middle of the spectrum after resolving all the conventional symmetries of the model, and hence are examples of towers of QMBS. For example, the states of the vacuum tower $\{ ( \eta ^ { \dagger } ) ^ { n } \left| \Omega \right. \}$ are exact eigenstates for the Hubbard model with additional electrostatic terms, i.e.,

$$
H _ { \mathrm { s c a r } } = H _ { \mathrm { H u b } } + \sum _ { \langle \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle \rangle } V _ { \mathbf { r } , \mathbf { r } ^ { \prime } } S _ { \mathbf { r } } ^ { z } S _ { \mathbf { r } ^ { \prime } } ^ { z } ,
$$

where $V _ { \mathbf { r } , \mathbf { r ^ { \prime } } }$ ’s are arbitrary real coefficients. This Hamiltonian $H _ { \mathrm { s c a r } }$ breaks the $S U ( 2 )$ symmetries of $H _ { \mathrm { H u b } }$ , and hence the states of the tower of Eq. (22) are examples of QMBS eigenstates of $H _ { \mathrm { s c a r } }$ . An exhaustive search of such nearest-neighbor terms that preserve $\{ ( \eta ^ { \dagger } ) ^ { n } \left| \Omega \right. \}$ as exact eigenstates was performed in Ref. [77], which includes the Hamiltonian of Eq. (23). Further, Ref. [76] identified some such terms and provided sufficient conditions for the preservation of such towers originating from an SGA, a formalism we will briefly discuss in Sec. 4.

3.1.2. Ferromagnetic Towers Notice that the SGA or dynamical symmetry is similar to systems where an $S U ( 2 )$ symmetry is “broken” by a constant magnetic field. Indeed, starting with an $S U ( 2 )$ -symmetric Hamiltonian $H _ { 0 }$ , adding magnetic field $B$ results in an SGA for the usual spin $S U ( 2 )$ symmetry

$$
H _ { B } = H _ { 0 } + B S ^ { z } , [ H _ { B } , S ^ { + } ] = B S ^ { + } , [ H _ { B } , \vec { S } ^ { 2 } ] = 0 , [ H _ { B } , S ^ { z } ] = 0 .
$$

$\ddagger$ There are other analytically tractable towers in $H _ { \mathrm { H u b } }$ obtained by the repeated action of $\eta ^ { \dagger }$ on certain spin-polarized eigenstate of $H _ { \mathrm { H u b } }$ , which are not the only ones in their quantum number sector, are in the middle of the spectrum, and have a sub-volume law scaling of $\mathrm { E E }$ [75]. These should be considered examples of QMBS in the Hubbard model.

For example, $H _ { 0 }$ can be the Hubbard model of Eq. (13), or the one-dimensional spin- $1 / 2$ Heisenberg model given by

$$
H _ { 0 } = \sum _ { j } J _ { j } \vec { S } _ { j } \cdot \vec { S } _ { j + 1 } .
$$

These Hamiltonians admit an exactly solvable “ferromagnetic” states of the form $| \psi _ { 0 } \rangle = | { \downarrow \cdots \downarrow } \rangle$ , say with energy $E _ { 0 }$ . The SGA condition of Eq. (24) ensures the existence of a “ferromagnetic tower” of eigenstates $\{ ( S ^ { + } ) ^ { n } \left| \psi _ { 0 } \right. \}$ , which are exact eigenstates of the Hamiltonian $H _ { B }$ with energies $\{ E _ { 0 } + B n \}$ for $0 \leq n \leq L + 1$ . While the states in this ferromagnetic tower of $H _ { B }$ are not considered scars of the Hamiltonian, local perturbations that break the SGA of Eq. (24) (for example, ones that that do not commute with $\vec { S } ^ { 2 }$ ) can be added that preserved the eigenstates of the ferromagnetic tower, leading to the features we discussed for the vacuum tower of the Hubbard model of Eq. (13). An exhaustive search for such types of terms was performed in Ref. [77]. This led to the discovery of physically relevant models with the ferromagnetic tower as QMBS, including some terms $H _ { \mathrm { D M I } }$ with a Dzyaloshinskii-Moriya Interaction (DMI) [78, 79, 80], e.g.,

$$
H _ { \mathrm { D M I } } = \sum _ { j } \hat { z } \cdot \left( \vec { S } _ { j } \times \vec { S } _ { j + 1 } \right) = \sum _ { j } \bigl ( S _ { j } ^ { x } S _ { j + 1 } ^ { y } - S _ { j } ^ { y } S _ { j + 1 } ^ { x } \bigr ) .
$$

3.1.3. Spin-1 XY Model Similar towers of QMBS are found in the spin-1 XY model [81], given by the Hamiltonian

$$
H _ { \mathrm { X Y } } = J \sum _ { \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle } ( S _ { \mathbf { r } } ^ { x } S _ { \mathbf { r ^ { \prime } } } ^ { x } + S _ { \mathbf { r } } ^ { y } S _ { \mathbf { r ^ { \prime } } } ^ { y } ) + h \underset { \mathbf { r } } { \sum } S _ { \mathbf { r } } ^ { z } + D \underset { \mathbf { r } } { \sum } ( S _ { \mathbf { r } } ^ { z } ) ^ { 2 } ,
$$

where $\langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle$ denote nearest-neighboring sites on a lattice, $\{ S _ { \mathbf { r } } ^ { \alpha } \}$ , $\alpha \in \{ x , y , z \}$ denote the spin-1 operators on site $\mathbf { r }$ . On a general lattice, $H _ { \mathrm { X Y } }$ only has a conventional $U ( 1 )$ symmetry generated by the total spin operator $\sum _ { \mathbf { r } } S _ { \mathbf { r } } ^ { z }$ , but it possesses simple spin-polarized such as $| \Omega \rangle = | --- - \rangle$ and $| \bar { \Omega } \rangle = | + \cdots + \rangle$ , where $-$ and $+$ denote on-site spin configurations with $S ^ { z } = - 1$ and $S ^ { z } = + 1$ respectively. Ref. [81] showed the existence of a tower of QMBS that connects the states $| \Omega \rangle$ and $\left| \bar { \Omega } \right.$ , of the form $\{ ( Q ^ { \dagger } ) ^ { n } \left. \Omega \right. \}$ with energies $\{ 2 h n \}$ , where $Q ^ { \dagger } \equiv \sum _ { \mathbf { r } } e ^ { i \pi \cdot \mathbf { r } } ( S _ { \mathbf { r } } ^ { + } ) ^ { 2 }$ is the quasiparticle creation operator, similar to $\eta ^ { \dagger }$ of Eq. (15). Indeed, in one dimension, the tower of states consists of multiple quasiparticles with momentum $\pi$ , similar to Eq. (22)

$$
\begin{array} { c } { { | \Omega \rangle = | - \textrm { --- --- } - \rangle , Q ^ { \dag } | \Omega \rangle = \displaystyle \sum _ { j } ( - 1 ) ^ { j } \ | - \ \cdots \ - \ + \ - \ \cdots \ - \rangle , } } \\ { { \mathrm { } } } \\ { { ( Q ^ { \dag } ) ^ { 2 } | \Omega \rangle = \displaystyle \sum _ { j , k } ( - 1 ) ^ { j + k } | - \cdots - + - \ \cdots - + - \cdots - \rangle , \ \cdots } } \\ { { \mathrm { } } } \\ { { \ \dots . . . \ , \ ( Q ^ { \dag } ) ^ { L } | \Omega \rangle = | \bar { \Omega } \rangle = | + \ + \ \cdots \ + \ + \rangle , } } \end{array}
$$

As discussed in Ref. [81], the states of this tower are generically in the middle of the spectrum of the $H _ { \mathrm { X Y } }$ after resolving all the conventional symmetries of the model, and hibit subextensive entanglement entropy scaling at most order [28, 38]. Up tthey have a sub-volume scaling of the entanglement entropy, (as we also discuss in logarithmically with system size. Re hSn|O†⇡(t)O⇡Sec. 3.3), hence they form examples of QMBS. These features are also evident in Fig. 3, It is instructive to compare the scarred states (2) with This space-time crwhere we show the entanglement entropy of the eigenstates of the spin-1 XY model models, in particular the “⌘-pairing” states of the Hub- traced back to the within a quantum number sector along with those for the QMBS eigenstates. These bard modelQMBS are similar to those in $H _ { \mathrm { s c a r } }$ nd the scarred states oof Eq. (34), and the $D = 0$ AKLT    limit of the Hamiltonian states with logarithmic entanglemof Eq. (27) admits an SGA with the operator $Q ^ { \dagger }$ [13, 36] obtained by equilibrium [28, 39];, similar to the Hubbard model (see acting repeatedly with some operator on a parent state. ETH, these no-go thEq. (18)). In fact, Ref. [77] established an exact correspondence between the tower of The ⌘-pairing example is unique in that it is protected that the eigenstateQMBS of Eq. (22) in the Hubbard and related models and tower of QMBS in the spin-1 operators of the Hamiltonian and the ⌘-pairing states significant consequeXY model of Eq. (28). In particular, the lowest and highest eigenstates of the towers are are the onrespectively identified (i.e., $| - \cdots - \rangle$ n thei and $| + \cdots + \rangle$ e symmetry secto correspond to $| 0 \cdots 0 \rangle$ tialize and $\vert \updownarrow \cdots \updownarrow \rangle$ m), and the raising operator $Q ^ { \dagger }$ gered rhin the spin-1 XY model was identified with the $\eta ^ { \dagger }$ bic aniso in the Hubbard model.

![](images/2dd60718f91321075faf76f4d0200945d714cb255d4029159c0fca0dc01437aa.jpg)  
FIG. 2. Bipartite entanglement entropy SA of eigenstates of imFigure 3. (Color online) Bipartite Entanglement Entropy (EE) $S _ { A }$ es that the spi as a function States in the zerof eigenstate energy $E$ 3      magnetization sector (smaller points) are the U(1) spin-rotatiof the one-dimensional spin-1 XY model of Eq. (27)(figure color coded by the density of states (warmer colors ireproduced from Ref. [81]). Data shown for a system of size $L = 1 0$ with the parameters $( h , D , J ) = ( 1 , 0 . 1 , 0 . 1 )$ he dashed line at S A = L2 ln 3  12 indicates with OBC within the sector zero total spin. The red dots depict SA for a random state. Larger red points indicate scarred states in the middlethe EE for the QMBS eigenstates, which lie in other quantum number sectors (apart from the circled state at $E = 1$ 6     |SL/2i inally at infinite tem), but nevertheless are clear outliers among other matrix ⇢ = e  H ineigenstates in the spectrum. Inset: Logarithmic scaling of the EE of the circled QMBS eigenstate as a function of the system size.

# AKLT ground state rather th3.2. Survey of other towers in the literature

not form a representation of the SU(2) algebra (4). It is    thus the lowest-wei3.2.1. AKLT Model The examples of towers of QMBS discussed in Sec. 3.1 share the an important outstanding question whether such a struc- resentation of the Sproperty that the raising and lowering operators for the towers of states were Hermitian determine the dynamical signatures of the scarred states, “nematic N´eel” statconjugates of each other, a property that is a direct consequence of the underlying SGA which (to the best of our knowledge) remain unknown. = O ✓ |mi of Eq. (19). However, not all towers of QMBS in the literature have this property. In For the scarred states presented here this is not the case, ifact the first example of a tower of QMBS, found in the spin-1 AKLT model in Ref. [15], deduced directly from the SU(2) algebra (violates this condition. The AKLT model consists of $L$ . Since this is an eige spin-1’s, and its Hamiltonian

reads

$$
H _ { \mathrm { A K L T } } = \sum _ { j } P _ { j , j + 1 } ^ { ( 2 ) } = \sum _ { j } \left( \frac { 1 } { 3 } + \frac { 1 } { 2 } \left( \vec { S } _ { j } \cdot \vec { S } _ { j + 1 } \right) + \frac { 1 } { 6 } ( \vec { S } _ { j } \cdot \vec { S } _ { j + 1 } ) ^ { 2 } \right) ,
$$

where the nearest-neighbor terms $P _ { j , j + 1 } ^ { ( 2 ) }$ are projectors of two neighboring spin-1’s on sites $j$ and $j + 1$ into total angular momentum spin-2 state, the sum over $j$ runs from 1 to $L$ or $L - 1$ for periodic boundary conditions (PBC) or open boundary conditions (OBC) respectively, and the position subscripts are modulo $L$ for PBC. The ground state $| G \rangle$ of of Eq. (29), also sometimes referred to as the AKLT state, is a frustrationfree ground state, i.e. $P _ { j , j + 1 } ^ { ( 2 ) } \left| G \right. = 0$ for any $j$ , and it can be elegantly expressed in in $H _ { \mathrm { A K L T } }$ were first constructed in the language of dimers in Ref. [15], following the construction of two exact low-energy eigenstates in Ref. [66]. While many such excited states are energetically close to the edge of the spectrum, an equally-spaced tower of exact eigenstates with energies in the bulk of the spectrum was obtained for even system sizes with PBC and for all system sizes with OBC.

The states of this tower are composed of multiple non-interacting quasiparticles dispersing with momentum $k = \pi$ (for PBC) on top of the ground state $| G \rangle$ , similar to the tower of Eq. (22) in the Hubbard model $H _ { \mathrm { H u b } }$ . The quasiparticle creation operator for this tower in $H _ { \mathrm { A K L T } }$ reads $\begin{array} { r l r } { Q ^ { \dagger } = \sum _ { j } ( - 1 ) ^ { j } ( S _ { j } ^ { + } ) ^ { 2 } } \end{array}$ , and the states $\{ ( Q ^ { \dagger } ) ^ { n } \left| G \right. \}$ are eigenstates of $H _ { \mathrm { A K L T } }$ with energies $\left\{ E = 2 n \right\}$ , total spin $\left\{ s = 2 n \right\}$ , and its $z$ -projection $\{ S _ { z } = 2 n \}$ . Hence they form an extensive tower of states starting from the ground state $| G \rangle$ with energy $E = 0$ to the highest excited “ferromagnetic” state $| F \rangle$ with energy $E = L$ . These eigenstates reside in the bulk of the spectrum after resolving all known symmetries of $H _ { \mathrm { A K L T } }$ , which include translation (for PBC), inversion, and $S U ( 2 )$ [15]. Moreover, these states obey a sub-volume-law scaling of their entanglement entropy, owing to their quasiparticle structure [64], as we will show in Sec. 3.3. Note that as a consequence of the $S U ( 2 )$ symmetry of $H _ { \mathrm { A K L T } }$ , there is a multiplet of $( 4 n + 1 )$ eigenstates associated with each “highest-weight” state $( Q ^ { \dagger } ) ^ { n } \left| G \right.$ . The “lowest-weight” states of the multiplet read $Q ^ { n } \left| G \right.$ , where $\begin{array} { r } { Q = \sum _ { j } { ( - 1 ) ^ { j } ( S _ { j } ^ { - } ) ^ { 2 } } } \end{array}$ , and these are eigenstates of $H _ { \mathrm { A K L T } }$ with energies $\{ E = 2 n \}$ , total spin $\{ s = 2 n \}$ , and its $z$ -projection $\{ S _ { z } = - 2 n \}$ . Hence, unlike the towers discussed in Sec. 3.1, the $Q$ operator is not a lowering operator for the tower created by the action of the $Q ^ { \dagger }$ operator, but they create the lowest and highest states of a multiplet. The lowering operator for the tower created by $Q ^ { \dagger }$ is believed to be a distinct (possibly non-local) operator $Q ^ { \prime }$ , as shown in Fig. 4.

3.2.2. General Structure of QMBS Towers We now comment on some general features of QMBS towers that appear in the literature. As evident from the above examples, towers of QMBS are comprised of “non-interacting” quasiparticles on top a product state (or more generally, on an MPS eigenstate with finite bond-dimension). Heuristically, the interaction between quasiparticles can be forbidden in two distinct ways, which is one distinguishing feature between the QMBS in the AKLT model and those discussed in Sec. 3.1.

First, interactions can be forbidden when there are no terms in the Hamiltonian that energetically penalize configurations of nearest-neighbor quasiparticles, which occurs in the examples discussed in Sec. 3.1. For example, in the $\eta$ -pairing tower of Eq. (22), the energy of the configuration $\mid \updownarrow \updownarrow \rangle$ with quasiparticles beside each other is not affected by any of the terms in the Hamiltonian $H _ { \mathrm { s c a r } }$ . On the other hand, the quasiparticles can have “emergent kinetic constraint” [82], where configurations with quasiparticles beside each other do not appear in the wavefunctions of states of the tower. Such a scenario occurs, for example, in the quasiparticle in the QMBS of the AKLT model, where the quasiparticle creation operator satisfies $( S _ { j } ^ { + } ) ^ { 2 } ( S _ { j + 1 } ^ { + } ) ^ { 2 } \left| G \right. = 0$ , implicitly disallowing any configuration where quasiparticles are beside each other. Towers of QMBS with this phenomenology were also found in the spin- $S$ $S O ( 3 )$ -symmetric AKLT models [15, 64], spin- $S$ $S O ( 2 S + 1 )$ -symmetric AKLT models in Ref. [83], and the towers of states in certain Domain-Wall-Conserving (DWC) models studied in Ref. [82], which share several features with the QMBS in the AKLT models.

These microscopic properties of quasiparticles can be used to systematically construct Hamiltonians with QMBS. For examples, such properties were utilized in Ref. [84] to systematically construct scarred models based on parent Hamiltonians of Matrix Product States (MPS) [46]. In particular, this led to the discovery of a 6- parameter family of Hamiltonians with $\{ ( Q ^ { \dagger } ) ^ { n } \left| G \right. \}$ as QMBS, of which $H _ { \mathrm { A K L T } }$ was a special case (The same family was independently discovered in Ref. [85] using a different approach, which we will discuss in Sec. 4.2). Similar approaches can be used to systematically construct families of Hamiltonians with the same tower of QMBS as the spin-1 XY model (see Eq. (27)) or families of Hamiltonians with $\eta$ -pairing states of Eq. (22)) [77].

3.2.3. Miscellaneous Examples All of the examples of QMBS discussed above consist of towers of single-site quasiparticles, i.e., the states are obtained by the multiple action of a quasiparticle creation operator that is a sum of on-site terms. A different class of models with towers of QMBS are those with raising operators that are multi-site quasiparticles, i.e., the quasiparticle creation operator is a sum of multi-site but local terms. These include the second tower of the spin-1 XY model discovered in Ref. [81] and subsequently studied in Ref. [86], where the origin of towers of eigenstates was traced to the existence of “virtual entanglement pairs”. Large classes of models with multi-site quasiparticle QMBS were constructed based on the Onsager algebra in Ref. [87, 88], and also systematically constructed from parent Hamiltonians of MPS in Ref. [84].

Finally, we note that equally spaced eigenstates and revivals in non-integrable models are known to appear in several other systems and lattices [89, 90, 91, 92], sometimes without a quasiparticle structure of the eigenstates. In addition, examples of QMBS where the “raising operator” $Q ^ { \dagger }$ is non-local were constructed in the context of systems with quantum group symmetries [83], as well as in the DWC model [85]. A tower of QMBS created by a non-local operator also appears in models constructed to embed “rainbow states” in the spectrum [93], which, unlike most examples of QMBS, obey a on numerical studies. They are, E = E + 2 m = 2 (n + m) 4Jn + (J  )L.volume-law scaling of EE under most choices of the bipartition while still violating ETH. : We emphasize here that the magnetization is not a con-Another example of a tower of QMBS and associated revivals with volume-law scaling S↵ , m = 0, 1, ..., L   2n , (52)        for all   pyr. ↵ .of EE was shown to exist in a certain multi-component system [94]. Apart from simple While the operator R† increases NDW by 2 in the origi-towers of states, Refs. [85, 83] construct examples of “pyramids” of QMBS created by nal Iadecola-Schecter towers, these new towers lie in sec-the actions of multiple raising and lowering operators on a simple eigenstate, e.g., as +j P 0j+1 shown in Fig. 4b.

![](images/7f7e5f3cb775b23cb952eb9d940eb60d5c55cfc227845b31ad92c1c0d16e5852.jpg)  
FIG. 3. “Pyramid” of exact states   Spyr.n,m ↵, Eq. (52), for sys-Figure 4. Various structures of QMBS. (a) Equally spaced tower of QMBS with ya raising operator $Q ^ { \dagger }$ size L = 8. Each point repand a lowering operator $Q ^ { \prime }$ ents an exact state, with, which might or might not be j      the Hermitian conjugate of $Q ^ { \dagger }$ DW     P 1. The raising operator is usually a sum of single-site number of domain walls NDW . The horizontal axis is the to-operators, although there are examples where it is a sum of multi-site operators or tacompletely non-local. $Q ^ { \dagger }$ mber and $Q ^ { \prime }$ ‘1’s: Pj P 1j , which is not a conserved quantity annihilate the highest and lowest states of the tower under the Hamiltonian, but these states are eigenstates of thisrespectively. (b) Figure reproduced from Ref. [85] showing a pyramid of QMBS in a in the spin-1/2         † 0† certain domain-wall conserving model. Each dot represents a QMBS eigenstate labelled netic states by certain quantum numbers $N _ { D W }$ |⌦0 i,and $\textstyle \sum _ { j } P _ { j } ^ { 1 }$ tate |Z2i, and a sample state. The various QMBS eigenstates are   Spyr.1,2 ↵ are alsorelated ladder operators such as $\mathcal { P } ^ { \dagger }$ el , $\mathcal { P } ^ { \prime \dagger }$ T , $R ^ { \dagger }$ Iadecola-Schecter towers are the, etc. This shows the wide variety of slopes marked with a dotted line, and our new towers arestructures of QMBS that can occur in physically relevant Hamiltonians.

# 0 + P 1 P 1  + P 0 + ... , The various towers form3.3. Entanglement of quasiparticle towers of states

new towers forming the horizontal levels. This is illus-We now turn to the EE of states composed of multiple quasiparticles on a fixed Sec. VI C once we further characterize the states   pyr. ↵background MPS, which form the towers of QMBS eigenstates in several models in · · 1 ih1 · · · 1 | j l,...,j 1 . (54) in Sec. VI B. We also give an alternate proof in Ap- Secs. 3.1 and 3.2. For pedagogical reasons, we restrict ourselves to one-dimensional systems and states of the form

$$
\left| \psi _ { n } \right. = ( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right. , Q ^ { \dagger } = \sum _ { j } e ^ { i k j } q _ { j } ^ { \dagger } ,
$$

’s.where $q _ { j } ^ { \dag }$ P† as is a single-site operator and $| \psi _ { 0 } \rangle$ ing domains to the left, and this would have is a MPS. These properties hold for the raising hese quantities being unchanged will become particularly clear after Sec. operators in several models with towers of QMBS, including the $\eta ^ { \dagger }$ I B. Tand $Q ^ { \dagger }$ efore, operators in ersion number is Ib = ( 1)n+m we can also go from  S n,m to  S n,m 1 by growing do-the Hubbard and AKLT models respectively. A simple way to bound the entanglement [H , †] = 2  †,entropy of states $\{ | \psi _ { n } \rangle \}$ mag-        Lastly, we note that numerical calculations of bipartite is to study its MPS form, which can be derived using the Matrix 2 and these states have energies entanglement entropy (EE) reveal these states to be EProduct Operator (MPO) form [95, 43, 96, 44, 64] of the creation operators $( Q ^ { \dagger } ) ^ { n }$ and the MPS form for $| \psi _ { 0 } \rangle$ . Simple translation invariant operators $\mathcal { O }$ typically admit an exact MPO representation in terms of a $d \times d \times \chi _ { m } \times \chi _ { m }$ tensors $M$ shown in Fig. 5a. Such an operator $\mathcal { O }$ is depicted diagrammatically in Fig. 5b. $d$ and $\chi _ { m }$ are referred to as physical and bond dimensions of the MPO respectively, and the diagrammatic notation is analogous to that for MPS, shown in Fig. 2b and discussed in Sec. 2.3. A state defined by the action of an MPO on an MPS has a natural MPS description in terms of the tensor $B$ depicted diagrammatically in Fig. 5c. $B$ is sometimes referred to as an MPO $\times$ MPS [64], and it has a bond dimension of $\chi _ { m } \chi$ , where $\chi _ { m }$ and $\chi$ are the bond dimensions of the MPO and MPS respectively. Hence, according to Eq. (11), the EE of the state $B$ represents is bounded by $S \leq \log \left( \chi _ { m } \chi \right)$ (see Fig. 5d).

![](images/cfb2612b39eea1390ef6a0409cfd3d9755edc44efae808d9d7edff828c56c5da.jpg)  
Figure 5. (a) $d { \times } d { \times } \chi _ { m } \times \chi _ { m }$ tensor representing an MPO. $d$ is the physical dimension, and $\chi _ { m }$ is the bond dimension (b) Operator $\boldsymbol { \mathcal { O } }$ represented in MPO form (c) Action of an MPO $M$ with bond dimension $\chi _ { m }$ on an MPS $A$ with bond dimension $\chi$ gives an MPS $B$ with bond dimension $\chi \chi _ { m }$ (d) MPS representation of the state $\mathcal { O } \left| \psi \right.$ . The entanglement entropy of the state $\mathcal { O } \left| \psi \right.$ is bounded by $\log \left( \chi \chi _ { m } \right)$ .

In the following, we use this bound to provide a simple proof for the sub-volume law EE scaling of the towers of QMBS eigenstates discussed in Secs. 3.1 and 3.2. Using standard methods [97, 98, 64], we can construct an efficient MPO of bond dimension $\chi _ { m } = n + 1$ for the operator $( Q ^ { \dagger } ) ^ { n }$ ( $n$ being an integer). Although a general expression is complicated (see Appendix A of Ref. [83]), $\ S$ in the simple case when $( q _ { j } ^ { \dag } ) ^ { 2 } = 0$ and $k = \pi$ , which happens in several QMBS models including the Hubbard and AKLT model, the $\ S$ The elements $M _ { \alpha , \beta }$ of the MPO tensor and the boundary vectors $( b _ { M } ^ { l } ) _ { \alpha }$ and $( b _ { M } ^ { r } ) _ { \alpha }$ in the general case read

$$
M _ { \alpha , \beta } = e ^ { i ( n - \alpha + 1 ) k } ( q ^ { \dagger } ) ^ { \beta - \alpha } \times \frac { ( n ! ) ^ { \frac { \beta - \alpha } { n } } } { ( \beta - \alpha ) ! } \delta _ { \beta \geq \alpha } , \quad ( b _ { M } ^ { l } ) _ { \alpha } = \delta _ { \alpha , 1 } , \quad ( b _ { M } ^ { r } ) _ { \alpha } = \delta _ { \alpha , n + 1 }
$$

MPO tensor and the boundary vectors read [64]

$$
M = \left( \begin{array} { c c c c c c } { { ( - 1 ) ^ { n } { \bf 1 } } } & { { ( - 1 ) ^ { n } q ^ { \dagger } } } & { { 0 } } & { { \ldots } } & { { 0 } } \\ { { 0 } } & { { ( - 1 ) ^ { n - 1 } { \bf 1 } } } & { { ( - 1 ) ^ { n - 1 } q ^ { \dagger } } } & { { \ddots } } & { { \vdots } } \\ { { \vdots } } & { { \ddots } } & { { \ddots } } & { { \ddots } } & { { 0 } } \\ { { \vdots } } & { { \ddots } } & { { \ddots } } & { { - { \bf 1 } } } & { { - q ^ { \dagger } } } \\ { { 0 } } & { { \ldots } } & { { \ldots } } & { { 0 } } & { { { \bf 1 } } } \end{array} \right) , \quad b _ { M } ^ { l } { \bf \Sigma } ^ { T } = \left( 1 \begin{array} { c c c c } { { \bf 0 } } & { { \ldots } } & { { \bf 0 } } \end{array} \right) ,
$$

If the bond dimension of the MPS representation of $| \psi _ { 0 } \rangle$ is $D$ , the state $\left| { \psi _ { n } } \right.$ has an MPS representation with bond dimension $\chi = D ( n + 1 )$ . This establishes an upper bound on the EE of the states of the tower to grow as $S \leq \log [ D ( n + 1 ) ]$ . For $\boldsymbol { D }$ that is independent of system size (since $| \psi _ { 0 } \rangle$ is typically the ground state), and for a state $\left| { \psi _ { n } } \right.$ with an extensive number of quasiparticles (meaning $n \propto L$ ), the EE thus grows with system size $L$ as $S \sim \log L$ , a sub-volume scaling. These results are consistent with the sub-volume law scaling found in states with multiple identical quasiparticles on top of a product state, which has been studied in a variety of settings [75, 99, 81], including the scaling depicted in the inset of Fig. 3. Further, exact results for the EE of certain quasiparticle eigenstates that appear as QMBS in various systems, including those where the raising operators do not exactly obey the precise properties of Eq. (30), have been obtained in Refs. [75, 81, 86, 83], and they all follow a similar sub-volume law scaling. Indeed, MPOs with bond dimension $\chi _ { m } \propto n$ can also be obtained for operators $( Q ^ { \dagger } ) ^ { n }$ when the quasiparticle creation operators $q _ { j } ^ { \dag }$ have supports over multiple sites or sometimes also when they are non-local [83], although writing out their explicit form can be tedious. These results show that towers of QMBS exhibit an EE scaling that is inconsistent with ETH predictions. On a different note, the MPS forms of the QMBS can also be used to identify “topological” properties such as projective representations of the MPS or degeneracies in their entanglement spectrum, as shown for the AKLT model in Ref. [64].

# 3.4. Revivals from simple initial states

Given a quasiparticle tower of equally-spaced QMBS of the form $\{ ( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right. \}$ with $0 \leq n \leq N - 1$ such that $( Q ^ { \dagger } ) ^ { N } \left| \psi _ { 0 } \right. = 0$ , it is natural to ask what kinds of simple initial states can be constructed within the QMBS subspace. The first example of such a construction was demonstrated in Ref. [82] in the context of the DWC model mentioned in Sec. 3.2. We illustrate this construction, focusing on one-dimensional systems where the quasiparticle creation operator $Q ^ { \dagger }$ has the form $\begin{array} { r } { Q ^ { \dagger } = \sum _ { j = 1 } ^ { L } e ^ { i k j } q _ { j } ^ { \dagger } } \end{array}$ , where $q _ { j } ^ { \dag }$ is a strictly local operator in the vicinity of site $j$ , possibly with support over multiple sites. For simplicity, we further assume that the quasiparticle creation operators on different sites commute, i.e. $[ q _ { l } ^ { \dagger } , q _ { m } ^ { \dagger } ] = 0$ , a feature that is true for several examples of QMBS. A simple family of initial states that is in the scarred subspace is then given by [82, 77, 100]

![](images/b567f9ebab917c3f7472e93d6d8aa8dfcbbb56bd6fcc82fb0cc21ad81c5a5d4e.jpg)  
Figure 6. (Color online) Fidelity of initial states of the form of $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ of Eq. (32) for the one-dimensional spin-1 XY Hamiltonian of Eq. (27) with OBC and $h = 1$ and system size $L = 1 0$ . The revivals occur due to the equal spacing of the QMBS eigenstates, hence the nature of the plot does not depend on the precise scarred Hamiltonian. The time period of the revivals is $2 \pi / \mathcal { E }$ , where $\varepsilon$ is the energy spacing between the states of the tower.

$$
\left. \psi _ { \mathrm { i n } } ( \xi ) \right. = \prod _ { j = 1 } ^ { L } \exp ( \xi e ^ { i k j } q _ { j } ^ { \dagger } ) \left. \psi _ { 0 } \right. = \exp ( \xi Q ^ { \dagger } ) \left. \psi _ { 0 } \right. = \sum _ { n = 0 } ^ { N } \frac { \xi ^ { n } } { n ! } ( Q ^ { \dagger } ) ^ { n } \left. \psi _ { 0 } \right. ,
$$

where we have excluded the normalization factor that depends on the precise details of $q _ { j } ^ { \dag }$ . Note that in several common examples of QMBS discussed in Sec. 3, $k = \pi$ and $( q _ { j } ^ { \dag } ) ^ { 2 } = 0$ , hence $\exp ( \xi e ^ { i k j } q _ { j } ^ { \dag } ) = ( 1 + ( - 1 ) ^ { j } \xi q _ { j } ^ { \dag } )$ . The fidelity $\mathcal { F } ( t )$ of Eq. (12) can be directly computed starting from the states of Eq. (32). If the QMBS states $\{ ( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right. \}$ have energies $\{ E _ { 0 } + n \mathcal { E } \}$ under a scarred Hamiltonian $H _ { \mathrm { s c a r } }$ , the expression for the fidelity (after including the normalization factor) reads

$$
\mathcal { F } ( t ) = \frac { \big |  \psi _ { \mathrm { i n } } ( \xi )  e ^ { - i H _ { \mathrm { s c a r t } } } \big \vert \psi _ { \mathrm { i n } } ( \xi )  \big | ^ { 2 } } { \big |  \psi _ { \mathrm { i n } } ( \xi ) \big \vert \psi _ { \mathrm { i n } } ( \xi )  \big \vert ^ { 2 } } = \frac { \big \vert \displaystyle \sum _ { n = 0 } ^ { N } \frac { \xi ^ { 2 n } e ^ { - i n \xi t } } { ( n ! ) ^ { 2 } } \mathcal { N } _ { n } \big \vert ^ { 2 } } { \big \vert \displaystyle \sum _ { n = 0 } ^ { N } \frac { \xi ^ { 2 n } } { ( n ! ) ^ { 2 } } \mathcal { N } _ { n } \big \vert ^ { 2 } } , \mathcal { N } _ { n } \equiv  \psi _ { 0 }  ( Q ) ^ { n } ( Q ^ { \dagger } ) ^ { n } \big \vert \mathfrak { a } ,
$$

where $\mathcal { N } _ { n }$ ’s are the normalization factor of the QMBS eigenstate $( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right.$ . While the normalization factors $\mathcal { N } _ { n }$ might be in general hard to compute analytically in general, they can be explicitly evaluated in some cases, e.g., in the spin-1 XY model [101] or the Hubbard model [75], which leads to dramatic simplifications in Eq. (33). Using the expression of Eq. (33), it is easy to see that $\textstyle { \mathcal { F } } ( t + { \frac { 2 \pi } { \varepsilon } } ) = { \mathcal { F } } ( t )$ , hence fidelity of the initial states $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ exhibits revivals with a time period given by $2 \pi / \mathcal { E }$ . In Fig. 6, we show the fidelity revivals for various values of $\xi$ for the spin-1 XY model. This periodicity is in stark contrast to the fidelity of a random state with the same energy expectation value as $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ , which typically quickly decays to a value exponentially small in system size.

Since $| \psi _ { i n } ( \xi ) \rangle$ is constructed by the action of $L$ one-site or two-site (depending on the number of sites $q _ { j } ^ { \dag }$ has support on) operators $\{ \exp ( \xi e ^ { i k j } q _ { j } ^ { \dagger } ) \}$ on $| \psi _ { 0 } \rangle$ , the bonddimension of its MPS representation is $\mathcal { O } ( 1 )$ more than the bond-dimension of the

MPS for $| \psi _ { 0 } \rangle$ . Hence, if $| \psi _ { 0 } \rangle$ obeys area-law entanglement (i.e., if it admits an MPS representation of finite bond dimension), the family of states $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ also obeys area-law entanglement, even though some of the states $( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right.$ are not area-law entangled as discussed in Sec. 3.3. Due to the MPS structure of $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ , we can construct its local parent Hamiltonian [46, 84] $H _ { \mathrm { i n } } ( \xi )$ for which $| \psi _ { \mathrm { i n } } ( \xi ) \rangle$ is an exact ground state, although not necessarily unique. An explicit construction of such a family of gapped parent Hamiltonians $H _ { \mathrm { i n } } ( \xi )$ is provided in Ref. [82], where they turn out to be closely related to the Rokhsar-Kivelson type Hamiltonians studied in Ref. [102]. This construction of initial states within the QMBS subspace that are gapped ground states of different Hamiltonians is highly desirable, since it provides an experimentally feasible method to build initial states that show anomalous dynamics.

# 4. Unified Formalisms

Given the large number of models exhibiting QMBS, there have been several attempts to unify them into systematic formalisms [103, 85, 76, 104, 105, 83]. In spite of these works, it is not clear to date whether any of these are exhaustive, and the precise relations between these formalisms are yet to be carefully worked out. Nevertheless, we now give a broad overview of the different approaches to unify QMBS, which roughly fall into three categories. Throughout this section, we use $H _ { \mathrm { s c a r } }$ to denote the Hamiltonian of interest, i.e., the one with QMBS eigenstates, $\tau$ to denote the subspace spanned by the QMBS eigenstates, and $Q ^ { \dagger }$ to refer to the raising operator. In particular, we will frequently refer back to the example of the Hubbard model discussed in Sec. 3.1, where $H _ { \mathrm { s c a r } }$ is given by Eq. (23). For convenience of illustration, we rewrite $H _ { \mathrm { s c a r } }$ here and split it into three parts

$$
\begin{array} { r l } & { H _ { \mathrm { s c a r } } = \displaystyle \widehat { T } + \widehat { U } + \widehat { V } , \quad \widehat { T } \equiv - \sum _ { \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle } t _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \widehat { T } _ { \mathbf { r } , \mathbf { r } ^ { \prime } } = - \sum _ { \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle } t _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \sum _ { \sigma \in \{ \uparrow , \downarrow \} } \big ( c _ { \mathbf { r } , \sigma } ^ { \dagger } c _ { \mathbf { r } ^ { \prime } , \sigma } + h . c . \big ) } \\ & { \qquad \displaystyle \widehat { U } \equiv \sum _ { \mathbf { r } } \left( U \widehat { n } _ { \mathbf { r } , \uparrow } \widehat { n } _ { \mathbf { r } , \downarrow } - \mu \sum _ { \sigma \in \{ \uparrow , \downarrow \} } \widehat { n } _ { \mathbf { r } , \sigma } \right) , \quad \widehat { V } \equiv \sum _ { \langle \mathbf { r } , \mathbf { r } ^ { \prime } \rangle \rangle } V _ { \mathbf { r } , \mathbf { r } ^ { \prime } } S _ { \mathbf { r } } ^ { z } S _ { \mathbf { r } ^ { \prime } } ^ { z } , } \end{array}
$$

where we have used the same notation as Eq. (23). The subspace $\tau$ and the raising operator $Q ^ { \dagger }$ corresponding to this model are given by

$$
Q ^ { \dagger } \equiv \eta ^ { \dagger } = \sum _ { \mathbf { r } } e ^ { i \pi \cdot \mathbf { r } } c _ { \mathbf { r } , \uparrow } ^ { \dagger } c _ { \mathbf { r } , \downarrow } ^ { \dagger } , \quad \mathcal { T } \equiv \mathrm { s p a n } \{ | \Omega \rangle , \eta ^ { \dagger } | \Omega \rangle , \cdots , ( \eta ^ { \dagger } ) ^ { L } | \Omega \rangle \} .
$$

# 4.1. Shiraishi-Mori embedding formalism

The first systematic method of “embedding” exact eigenstates into the spectrum of non-integrable Hamiltonians was introduced by Shiraishi and Mori (SM) in Ref. [103]. The SM formalism uses a set of strictly local (generically multi-site) projectors $\{ P _ { i } \}$ that need not commute with each other, and a target space $\tau$ defined as the common subspace of states annihilated by all the projectors, i.e. $\mathcal { T } = \{ | \psi \rangle : P _ { i } | \psi \rangle = 0 \forall i \}$ . Given a target space $\tau$ , any term $H _ { 0 }$ that commutes with all of the $P _ { i }$ ’s leaves the target space invariant (i.e, $H _ { 0 } \left| \psi \right. \in \mathcal { T }$ if $| \psi \rangle \in { \mathcal { T } }$ since $P _ { i } H _ { 0 } \left| \psi \right. = H _ { 0 } P _ { i } \left| \psi \right. = 0 $ ). Hence, $H _ { 0 }$ can be diagonalized within $\tau$ , and the corresponding eigenstates are the eigenstates of any Hamiltonian $H _ { \mathrm { s c a r } }$ of the form

$$
H _ { \mathrm { s c a r } } = \sum _ { i } P _ { i } h _ { i } P _ { i } + H _ { 0 } , [ H _ { 0 } , P _ { i } ] = 0 \forall i .
$$

where $h _ { i }$ is an arbitrary local operator. For generic choices of $h _ { i }$ , $H _ { \mathrm { s c a r } }$ is non-integrable, and the states in $\tau$ are eigenstates in the middle of the spectrum. Provided the states have sub-volume-law EE scaling, they are violations of strong ETH of the Hamiltonian $H _ { \mathrm { s c a r } }$ , and thus examples of QMBS of $H _ { \mathrm { s c a r } }$ . While the original examples in Ref. [103] only included “isolated” QMBS that are not equally spaced towers of states (we discuss these in Sec. 5), it was later realized that towers of QMBS in several models can also be captured by this formalism. Examples include the QMBS towers in the spin-1 XY model (see Appendix C of Ref. [81]), $\eta$ -pairing in the Hubbard model [77] and $H _ { \mathrm { s c a r } }$ of Eq. (34), the toy model studied in Ref. [12], although recasting these Hamiltonians in the form of Eq. (36) can be tedious.

# 4.2. SGA-based formalism

4.2.1. MLM Framework A different unified framework was introduced by Mark-LinMotrunich (MLM) in Ref. [85], generalizing the idea of SGAs discussed in Sec. 3.1. They consider a manifold of states $\mathcal { W }$ , and impose the following SGA condition restricted to $\mathcal { W }$

$$
[ H _ { \mathrm { s c a r } } , Q ^ { \dagger } ] \mathcal { W } = \mathcal { E } Q ^ { \dagger } \mathcal { W } , \quad Q ^ { \dagger } \mathcal { W } \subseteq \mathcal { W } ,
$$

where $Q ^ { \dagger }$ is the QMBS tower creation operator, and $\widehat { O } w$ is an abuse of notation that refers to the subspace obtained by the action of an operator $\widehat { O }$ onto states in $\mathcal { W }$ . Note that when $\mathcal { W }$ is the full Hilbert space, Eq. (37) reduces to the the SGA condition of Eq. (19). Consequently, given an eigenstate $| \psi _ { 0 } \rangle$ of $H _ { \mathrm { s c a r } }$ within the subspace $\mathcal { W }$ , we obtain a tower of eigenstates of $H _ { \mathrm { s c a r } }$ of the form $\{ ( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right. \}$ . However, note that unless $\mathcal { W }$ is the full Hilbert space, Eq. (37) does not imply that the lowering operator of the tower is the Hermitian conjugate of $Q ^ { \dagger }$ ; hence in general it can be a different operator $Q ^ { \prime }$ , as shown in Fig. 4a.

For example, for the deformations of the Hubbard model such as $H _ { \mathrm { s c a r } }$ of Eq. (34), the subspace $\mathcal { W }$ is equal to the subspace $\tau$ spanned by the tower of states in Eq. (35). Similarly, this formalism was demonstrated to capture all the QMBS in the spin-1 XY model of Eq. (27), all the spin- $S$ $S O ( 3 )$ -symmetric AKLT models, and the DWC model discussed in Sec. 3. Insights from the MLM formalism also led to the discovery of large families of nearest-neighbor Hamiltonians that share the same QMBS eigenstates as these models. Note that although the subspace $\mathcal { W }$ is the same as the QMBS subspace $\tau$ in simple examples, it was sometimes observed to be larger than the subspace $\tau$ , for example in the case of the AKLT model [85].

4.2.2. RSGA formalism A closely related formalism was independently introduced in Ref. [76], where, instead of working with manifolds of states $\mathcal { W }$ , sufficient conditions for the existence of towers of eigenstates of the form $\{ ( Q ^ { \dagger } ) ^ { n } \left| \psi _ { 0 } \right. \}$ were provided in terms of the state $| \psi _ { 0 } \rangle$ , the Hamiltonian $H _ { \mathrm { s c a r } }$ , and the operator $Q ^ { \dagger }$ . In particular, defining $H _ { 0 } \equiv H _ { \mathrm { s c a r } }$ , $H _ { n + 1 } \equiv [ H _ { n } , Q ^ { \dagger } ]$ , $\forall n \ \geq \ 0$ , examples of QMBS were said to exhibit a Restricted Spectrum Generating Algebra of order $M$ (RSGA- $M$ ) if the following conditions are satisfied

$$
\begin{array} { r l } & { \mathrm { ( i ) } H _ { \mathrm { s c a r } } | \psi _ { 0 } \rangle = E _ { 0 } | \psi _ { 0 } \rangle , \quad \mathrm { ( i i ) } H _ { 1 } | \psi _ { 0 } \rangle = \mathcal { E } Q ^ { \dagger } | \psi _ { 0 } \rangle } \\ & { \mathrm { ( i i i ) } H _ { n } | \psi _ { 0 } \rangle = 0 \forall n , 2 \leq n \leq M , \quad \mathrm { ( i v ) } \left\{ \begin{array} { l l } { H _ { n } \neq 0 } n \leq M \right.} & { n \leq M } \\ { H _ { n } = 0 } n = M + 1  \end{array}  .  \end{array}
$$

Explicit examples of QMBS in Hubbard-like models exhibiting an RSGA- $M$ for any $M$ were constructed in Ref. [76]. For example, $H _ { \mathrm { s c a r } }$ of Eq. (23) can be shown to satisfy Eq. (38) with $| \psi _ { 0 } \rangle = | \Omega \rangle$ , ${ \mathcal { E } } = ( U { - } 2 \mu )$ , $Q ^ { \dagger } = \eta ^ { \dagger }$ , $E _ { 0 } = 0$ for $M = 1$ , hence it falls into the category of RSGA-1. The RSGA formalism provides a finer classification of QMBS that are part of the MLM formalism. For example, the spin-1 XY model exhibits an RSGA-1, while the spin-1 AKLT model exhibits an RSGA-2. Recently, Ref. [106] connected the conditions of Eq. (38) to the properties of spherical tensor operators, which were then used to systematically construct families of QMBS Hamiltonians satisfying the RSGA conditions. Note that similar to the MLM formalism, Eq. (38) does not restrict the form of the lowering operator of the tower to be the Hermitian conjugate of $Q ^ { \dagger }$ ; hence in general it can be a different operator $Q ^ { \prime }$ , as shown in Fig. 4a.

# 4.3. Symmetry-based formalisms

The SGA-based formalisms discussed in Sec. 4.2 were subsequently extended in Refs. [105, 83, 104]. We refer to these as symmetry-based formalisms since the starting points for the construction of $H _ { \mathrm { s c a r } }$ are highly symmetric Hamiltonians for which the the QMBS are degenerate eigenstates, and the raising and lowering operators $Q$ and $Q ^ { \dagger }$ are symmetries. The search for such symmetric Hamiltonians was already initiated in Ref. [77], which employed similar ingredients as the symmetry-based formalisms we discuss below, along with the MLM framework to systematically search for Hamiltonians with QMBS. The symmetry-based formalisms are summarized in Fig. 7, and can be broadly classified into two categories.

4.3.1. Quasisymmetry and Tunnels to Towers Formalisms To construct the appropriate symmetric Hamiltonian, Refs. [105, 83] focus on the symmetry algebra generated by the raising and lowering operators $Q$ and $Q ^ { \dagger }$ , which is $S U ( 2 )$ in the case of $\eta$ -pairing discussed in Sec. 3.1 (see Eq. (17)).

In Ref. [105], the Hamiltonian $H _ { \mathrm { s c a r } }$ exhibiting towers of QMBS is decomposed into two parts

$$
H _ { \mathrm { s c a r } } = H _ { \mathrm { q - s y m } } + H _ { \mathrm { l i f t } } ,
$$

![](images/6ebfd1fbaca456dabcb8baa6b059e94c3495c574a735c5e7b5ac6f65db2b30de.jpg)  
Figure 7. Schematic overview of the symmetry-based unified formalisms for QMBS, discussed in Sec. 4.3. The figure only shows the eigenstates of interest, which eventually form the QMBS of $H _ { \mathrm { s c a r } }$ . (a) Spectrum of a symmetric Hamiltonian $H _ { \mathrm { s y m } }$ . The degeneracy can either be viewed to be a consequence of the non-Abelian symmetry (TT formalism) or due to the fact that they are singlets of the group generated by terms of $H _ { \mathrm { s y m } }$ (GI formalism). The eigenstates are uniquely specified by certain symmetry quantum numbers of $H _ { \mathrm { s y m } }$ . (b) Spectrum of the Hamiltonian $H _ { \mathrm { S G A } } = H _ { \mathrm { s y m } } + H _ { \mathrm { l i f t } }$ that appears in the TT formalism. While the degeneracy of these eigenstates is lifted, the eigenstates are still uniquely specified by certain symmetry quantum numbers of the $H _ { \mathrm { S G A } }$ . (c) Spectrum of the Hamiltonian $H _ { \mathrm { q - s y m } } = H _ { \mathrm { s y m } } + H _ { \mathrm { a n n } }$ that appears in the QS and GI formalisms, showing a manifold of exactly degenerate eigenstates. The symmetry of $H _ { \mathrm { s y m } }$ is broken by the addition of $H _ { \mathrm { a n n } }$ , but the degeneracy of the eigenstates is preserved. (d) Spectrum of the Hamiltonian ${ \cal H } _ { \mathrm { s c a r } } = H _ { \mathrm { q - s y m } } + H _ { \mathrm { l i f t } } =$ $H _ { \mathrm { S G A } } + H _ { \mathrm { a n n } }$ . Here the eigenstates are referred to as towers of QMBS, since they are typically in the middle of the spectrum, and are not distinguished by any symmetry quantum number of $H _ { \mathrm { s c a r } }$ .

where the QMBS eigenstates are degenerate in $H _ { \mathrm { q - s y m } }$ , and $H _ { \mathrm { l i f t } }$ lifts their degeneracy into an equally spaced tower of states, analogous to a magnetic field (see Figs. 7c and 7d). The degeneracy of the QMBS eigenstates in $H _ { \mathrm { q - s y m } }$ is shown to be a consequence of their invariance under a “Quasisymmetry” (QS), which is defined to be a usual on-site symmetry restricted to a particular subspace of the full Hilbert space. In particular, given any group element $g$ of a symmetry group $G$ with the on-site unitary action $\widehat { u } ( g )$ , a subspace $\mathcal { W }$ is referred to as having a quasisymmetry if it is invariant under the action of the symmetry group, i.e., if ${ \widehat { u } } ( g ) \warrow \subseteq \mathcal { W }$ for all $g \in G$ . For example, in the Hubbard model, the subspace $\tau$ of Eq. (35) is said to possess an $S U ( 2 )$ quasisymmetry, since it is invariant under the action of the pseudospin $S U ( 2 )$ unitary operators $\widehat { u } ( \vec { \alpha } ) = \exp ( i \vec { \alpha } \cdot \vec { \eta } )$ . Ref. [105] provides a systematic method, similar to the Shiraishi-Mori construction of Sec. 4.1, to construct Hamiltonians $H _ { \mathrm { q - s y m } }$ with the desired quasisymmetric subspace as a degenerate eigenspace. In fact, in the cases where the SM formalism and the QS formalisms overlap, the first term in Eq. (36) is an example of $H _ { \mathrm { q - s y m } }$ . For example, given the quasisymmetric subspace $\tau$ of Eq. (35), one such Hamiltonian is $H _ { \mathrm { q - s y m } } = \widehat { T } + \widehat { V }$ . Further, in the case where the quasisymmetry is a Lie group, Ref. [105] shows that there are natural candidates for $H _ { \mathrm { l i f t } }$ that lifts the degeneracy of the quasisymmetric subspace in $H _ { \mathrm { q - s y m } }$ . In the case of the subspace $\tau$ , one such Hamiltonian is $H _ { \mathrm { l i f t } } = \widehat { U }$ , which lifts the degeneracy into equally spaced towers of states with ${ \mathcal { E } } = ( U - 2 \mu )$ . In all, this provides a systematic approach to construct Hamiltonians with towers of QMBS, which have the form of Eq. (39) As illustrated in Ref. [105], this quasisymmetry formalism captures several examples of QMBS in the literature. Further, the notion of quasisymmetries and the associated formalism were recently generalized to include many additional examples of QMBS [100].

On the other hand, Ref. [83] exemplified a “Tunnels to Towers” (TT) approach to systematically construct models with towers of states, where Hamiltonians $H _ { \mathrm { s c a r } }$ exhibiting QMBS is decomposed into three parts

$$
H _ { \mathrm { s c a r } } = H _ { \mathrm { s y m } } + H _ { \mathrm { l i f t } } + H _ { \mathrm { a n n } } .
$$

$H _ { \mathrm { s y m } }$ is a Hamiltonian with a conventional non-Abelian symmetry such as $S U ( 2 )$ that protects the degeneracy of a multiplet of eigenstates that eventually become the tower of QMBS of $H _ { \mathrm { s c a r } }$ (see Fig. 7a). In this construction, the eigenstates that are part of the chosen multiplet are uniquely specified by their quantum numbers under symmetries of $H _ { \mathrm { s y m } }$ , and are related by the actions of raising and lowering operators associated with the non-Abelian symmetry (e.g. by $S ^ { + }$ and $S ^ { - }$ in the case of $S U ( 2 )$ ) $H _ { \mathrm { l i f t } }$ is a term that can be systematically added to lift the degeneracy of these eigenstates of $H _ { \mathrm { s y m } }$ into an equally spaced tower (see Fig. 7b), such that the resulting Hamiltonian, given by

$$
H _ { \mathrm { S G A } } = H _ { \mathrm { s y m } } + H _ { \mathrm { l i f t } } ,
$$

exhibits an SGA property of Eq. (19). Nevertheless, these eigenstates are still not referred to as examples of QMBS of $H _ { \mathrm { S G A } }$ since they can still be uniquely specified by quantum numbers under symmetries of $H _ { \mathrm { S G A } }$ (see Fig. 7b). Finally $H _ { \mathrm { a n n } }$ contains terms that annihilate the tower of states and can be systematically added to break the SGA property of $H _ { \mathrm { S G A } }$ while preserving (typically annihilating) the tower of states as eigenstates, arriving at $H _ { \mathrm { s c a r } }$ (see Figs. 7b and 7d). For example, in the case of $H _ { \mathrm { s c a r } }$ of Eq. (34), the symmetric Hamiltonian is $H _ { \mathrm { s y m } } = \widehat { T }$ , which possess the pseudospin $S U ( 2 )$ symmetry, and the multiplet of degenerate eigenstates (with the degeneracy protected by the pseudospin $S U ( 2 )$ symmetry) is the subspace $\tau$ of Eq. (35). Further, the term that lifts the degeneracy of this multiplet of states is $H _ { \mathrm { l i f t } } = \widehat { U }$ . $H _ { \mathrm { S G A } }$ is thus the usual Hubbard model $H _ { \mathrm { H u b } }$ of Eq. (13), which exhibits an SGA of Eq. (18), as discussed in Sec. 3.1. Finally, the term that breaks the SGA property while annihilating the eigenstates in $\tau$ is $H _ { \mathrm { a n n } } = \widehat { V }$ , and thus the decomposition of $H _ { \mathrm { s c a r } }$ in Eq. (34) is directly the TT decomposition.

As evident from the example of $H _ { \mathrm { s c a r } }$ of Eq. (34), the QS and TT constructions of Refs. [105, 83] reproduce the SGA-based construction of scars discussed in Refs. [77, 76] when the symmetry group is restricted to $S U ( 2 )$ . Further, these formalisms are also closely related to each other, and in the cases they overlap, the $H _ { \mathrm { q - s y m } }$ in the QS formalism can be decomposed as (see Figs. 7a and 7c)

$$
H _ { \mathrm { q - s y m } } = H _ { \mathrm { s y m } } + H _ { \mathrm { a n n } } ,
$$

and can be interpreted in the language of the TT formalism and vice-versa. Apart from towers of states, both mechanisms were also demonstrated for $S U ( 3 )$ groups, where two independent raising operators lead to “pyramids” of QMBS instead of towers. However, they differ in certain aspects. While the QS formalism applies only to groups protecting the degeneracy in $H _ { \mathrm { s y m } }$ , the TT mechanism was also demonstrated for $S U ( 2 ) _ { q }$ , a quantum group protecting the degeneracy, in which case the raising and lowering operators for the towers of states are non-local in nature. On the other hand, for the TT formalism to work, it requires $H _ { \mathrm { s y m } }$ to already possess analytically tractable eigenstates, which is a built-in feature in the QS formalism.

4.3.2. Group Invariant Formalism A complementary understanding of towers of QMBS was provided in a Group-Invariant (GI) formalism introduced in Ref. [104]. The starting points are symmetric Hamiltonians $H _ { \mathrm { s y m } }$ that are quadratic fermionic hopping terms of the form $\begin{array} { r } { T _ { A } = \sum _ { \mathbf { r } , \mathbf { r } ^ { \prime } , \sigma } A _ { \mathbf { r } , \mathbf { r } ^ { \prime } } c _ { \mathbf { r } , \sigma } ^ { \dagger } c _ { \mathbf { r } ^ { \prime } , \sigma } } \end{array}$ on $L$ sites where $A$ is a Hermitian matrix, and the indices $\mathbf { r }$ and $\sigma$ label the lattice site and the spin respectively. Instead of studying the symmetry group of such Hamiltonians, Ref. [104] focuses on the algebra generated by individual terms in $H _ { \mathrm { s y m } }$ . For example, for $H _ { \mathrm { s c a r } }$ in Eq. (34), the corresponding $H _ { \mathrm { s y m } }$ is $\widehat { T }$ , and the object of interest in the GI formalism is the algebra generated by the individual nearest-neighbor hopping terms $\{ \widehat { T } _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \}$ . Such quadratic hopping terms $\{ T _ { A } \}$ are shown to be the generators of a Lie group, e.g., $S O ( L )$ in the case of $\{ \widehat { T } _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \}$ . The associated symmetry group (i.e., the group of all unitary operators that commute with all these quadratic terms $\{ T _ { A } \}$ ) is a different Lie group, e.g., $S O ( 4 ) \approx ( S U ( 2 ) \times S U ( 2 ) ) / Z _ { 2 }$ in the case of $\{ \hat { T } _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \}$ , which is usually referred to as the “symmetry group” of the system. While QS and TT formalisms use the properties of the latter symmetry group to construct Hamiltonians with towers of QMBS, the GI formalism constructs Hamiltonians with QMBS using the properties of the former group (e.g., $S O ( L )$ ). In particular, they show that several examples of QMBS states are “invariant” under the action of the Lie group generated by the quadratic terms. These states are referred to as one-dimensional representations or “singlets” of corresponding Lie groups. For example, the QMBS eigenstates in $\tau$ of Eq. (35) are all annihilated by individual hopping terms $\{ \widehat { T } _ { \mathbf { r } , \mathbf { r } ^ { \prime } } \}$ , and hence are invariant under the action of the $S O ( L )$ group generated by these terms (i.e., the states are referred to as singlets of $S O ( L )$ ). Hence the degeneracy of the QMBS eigenstates under $H _ { \mathrm { s y m } }$ shown in Fig. 7a is viewed to be a consequence of the states being annihilated by the terms of $H _ { \mathrm { s y m } }$ (i.e., they are singlets of the group generated by the terms of $H _ { \mathrm { s y m } }$ ). Using the fact that the singlets are annihilated by the quadratic terms,

Ref. [104] provides a systematic construction for $H _ { \mathrm { s c a r } }$ , similar to the Shiraishi-Mori construction of Sec. 4.1, which can be written in the form

$$
H _ { \mathrm { s c a r } } = \sum _ { A } O _ { A } T _ { A } + H _ { \mathrm { l i f t } } ,
$$

where $\{ O _ { A } \}$ are arbitrary operators, the summation runs over some set of matrices $A$ , and $H _ { \mathrm { l i f t } }$ is some Hamiltonian that leaves the singlet space (i.e., the QMBS space) invariant, which guarantees that singlets of the group generated by $\{ T _ { A } \}$ are generically non-degenerate eigenstates of $H _ { \mathrm { s c a r } }$ . Further, note that the first term in Eq. (43) is equivalent to $H _ { \mathrm { q - s y m } }$ in the QS construction (see Fig. 7c) and also to the first term in the SM formalism of Eq. (36). Note that Eq. (43) can also be related to the TT construction by decomposing the first term in Eq. (43) according to Eq. (42).

An advantage of the GI formalism is that it reveals large symmetries of the QMBS eigenstates that are not evident in the QS and TT formalisms. For example, since the states in $\tau$ of Eq. (35) are invariant under the action of the group $S O ( L )$ , they can be viewed as being $S O ( L )$ -symmetric, which in particular implies that they are invariant under a permutation of the sites of the lattice (since the permutation group $S _ { L }$ is a subgroup of $S O ( L )$ ). Note that this formalism was recently extended to include additional examples of QMBS in fermionic Hamiltonians [107].

# 5. Isolated QMBS

While QMBS are commonly associated with revivals and the existence of towers of equally-spaced eigenstates in the spectrum, several examples of QMBS that do not involve a exactly solvable tower of states. Such examples consist of any number of states embedded in the middle of the spectrum, ranging from an $\mathcal { O } ( 1 )$ number to exponentially many. Some examples of isolated QMBS are shown in Fig. 8.

# 5.1. Survey of isolated QMBS

The Shiraishi-Mori (SM) formalism discussed in Sec. 4.1 was introduced in Ref. [103] to systematically embed QMBS eigenstates in the middle of the spectrum of nonintegrable Hamiltonians of the form of Eq. (36). This formalism was explicitly demonstrated in Ref. [103] by constructing such a non-integrable Hamiltonian with two Majumdar-Ghosh Hamiltonian ground states [109] as QMBS eigenstates in the middle of its spectrum. This construction utilized the frustration-free property of the Majumdar-Ghosh Hamiltonian ground states, i.e., they are annihilated by individual three-site projectors $P _ { i }$ ’s, and as discussed in Sec. 4.1, they form the target subspace $\tau$ . This procedure can be applied to other Valence Bond States including AKLT state, which have the property that they are annihilated by an appropriate choice of local operators $P _ { i }$ [16, 109]. In fact, a larger class of states can be a part of the target space $\tau$ . For example, in the case of states with MPS representation in onedimension (or PEPS in higher dimensions), the appropriate $P _ { i }$ ’s can be derived using the

![](images/472802bbbcf33a5eefef41a4437dee660a75df639d7dfc4e23321a11823d9766.jpg)  
FIG. 2. (Color online) Entanglement entropy of the eigenstates of to eacFigure 8. (Color online) Examples of Isolated QMBS. (a) Figure reproduced from Hamiltonian (2) for a real-space bipartition of the system into two lattice Ref. [103] shows the ETH violation in an isolated QMBS via the expectation value values of (1/L) i P i for all energy eigenstates.                 ⌥ of a certain local operator. The inset shows the expectation value in an isolated well-separated from the highly entangled states. onal gQMBS, which strongly deviates from that of typical states in the spectrum. (b) Figure Wilsoreproduced from Ref. [108] shows the EE of the eigenstates as a function of energy utlying value of (1/L) i P i from its microcanon-in a certain Hamiltonian exhibiting isolated QMBS that show topological order. The erage denoted by r1 for all energy   circled point is the QMBS eigenstate.

Being gapped at   =   = 0, the SPT phase extends to non- versaparent Hamiltonian construction [46, 84] or via Eigenstate-to-Hamiltonian construction s re- spin operatoralgorithms [110, 111].

2   1The null state for   =   = 0 is an eigenstate of the choicOther examples of isolated QMBS in the literature include Hamiltonians with ded  i  3  i 1 ·  i   i ·  i+1   i 1 ·  i+1  2 Zi 1 Xi Zi+1 operators, i = 1, · · · , 2L, with eigevalue +1. We of QiQMBS possessing (symmetry-protected) topological order [108, 112, 113], certain QMBS this (4)    | · · ·  i  1    2    state of Eq. (4a) is  that appear in frustrated models [90, 114, 92], “dimerized” states in lattice models with em- The analyses on the Majumdar-Ghosh model [54], studiesupersymmetry in arbitrary dimensions [115], exact localized states in Hubbard-like ergy whose Hamiltonian is H  MG := i P i , tell that H  MG| i 1 2 | · · ·  i  from models [67], and certain eigenstates in transverse field Ising ladders [88] or Abelian obtained via a similarity transformation with Exalattice gauge theory on small ladders [116]. We note that many of these examples of ghly  0  1 mode2D .isolated QMBS appear to be special cases of the SM formalism, although the connection L/ 2is not always immediately obvious.

| 1MGi := Y |v2n 1,2ni , | 2MGi := Y |v2n,2n+1i ,Finally, we note that Ref. [103] also illustrated an example of embedding where the subspace $\tau$ n=1 n=0         has an exponentially large dimension (while being a measure-zero set in line muting pieces H1D1 and H1D2 , one must show that each compo-the thermodynamic limit). Although eigenstates within that subspace are not solvable, gor- | i,j i     nent alone is non-integrable. We shall reduce the calculationthey nevertheless violate the conventional form of ETH [103, 26]. However, the subspace with 1 the topologically trivial warm up example of the Hamiltoniancan also be thought of as an exponentially large “Krylov subspace” distinguished by a ded 2 i j i j H( ) in Eq. (2), presented previously. The mapping is via a where non-local symmetry [27, 117], which makes it closer to examples of fragmentation that we will discuss in Sec. 6.

# +1). cluding a5.2. PXP models

MGˆ i which maps Q1Da, j into Qe1Da, j .. = W Q1Da, j W† where the plAn important class of isolated exact QMBS eigenstates appear in the context of PXP ruct  MG | MGi         1D   ⇣ Z X Z +Z X Z ⌘ uses tmodels, an effective model for the dynamics of Rydberg atoms [102, 8] on arbitrary one- ˆ ˆ ea, j     j lattices or graphs. As discussed in Sec. 1, the experimental realization and the h L ˆapproximate QMBS in the PXP model played an important role in the emergence of la- nianQMBS as a field. For convenience and due to its importance, we briefly describe the system here and refer readers to the reviews on the subject for more details [13, 14].

5.2.1. Model and Approximate QMBS In a certain limit where the nearest neighbor van-der-Walls interaction between Rydberg atoms is much larger than the detuning and the Rabi frequency, the Rydberg atoms can be modelled by two-level systems, either in its ground state or excited state, which we denote by $\downarrow$ and $\uparrow$ respectively [118, 8]. Furthermore, in this limit, the interactions between excited Rydberg atoms effectively forbid the simultaneous excitation of nearest-neighbor atoms, hence the effective lowenergy Hilbert space consists of all configurations without nearest neighbor excitations (i.e. configurations of the form $| \cdots \uparrow \uparrow \cdots \rangle$ are absent), which is sometimes referred to as the Fibonacci Hilbert space [118]. The effective Hamiltonian $H _ { \mathrm { P X P } }$ within this lowenergy subspace allows Rydberg atoms to freely transition between their ground and excited states provided neighboring atoms are excited [118]. Its expression reads (with PBC)

$$
H _ { \mathrm { P X P } } = \left\{ \begin{array} { l l } { \sum _ { j } P _ { j - 1 } X _ { j } P _ { j + 1 } } & { \mathrm { i n ~ o n e ~ d i m e n s i o n } } \\ { \sum _ { j } \left( X _ { j } \prod _ { i \in N ( j ) } P _ { i } \right) } & { \mathrm { o n ~ a r b i t r a r y ~ l a t t i c e s } } \end{array} \right. ,
$$

where $j$ runs over the sites of the lattice, $P _ { j } ~ = ~ ( \vert \downarrow \rangle \langle \downarrow \vert ) _ { j }$ is a projector onto the ground state of the atom on site $j$ that and $N ( j )$ denotes the set of neighbors of site $j$ . Note that the PXP Hamiltonian of Eq. (44) cannot create any nearest-neighbor excitations, and hence preserves the Fibonacci Hilbert space. The PXP model in any dimension admits a particle-hole symmetry generated by the operator $\Pi _ { j } Z _ { j }$ [9], where $Z _ { j }$ is the Pauli- $Z$ matrix acting on site $j$ , hence their energy spectra are symmetric around $E = 0$ . In addition, on lattices on which the PXP model has an inversion symmetry (e.g. the 1d PXP model), exhibit an exponentially large manifold of zero energy ( $E = 0$ ) eigenstates that can be shown to be a consequence of the inversion and particle-hole symmetries [8, 9, 119, 120]. Note that the 1d PXP model also appears as an effective Hamiltonian in a variety of different contexts, including Fibonacci anyon chains [121, 118, 122], Ising models on dimer ladders [123, 124], lattice gauge theories [125, 126], as well as in models with dipole moment conservation [127, 17], in particular the quantum Hall effect on a thin torus [120]. The 1d PXP model has been observed to host an approximate tower of QMBS that leads to anomalously long revivals [7, 8, 9]. These approximate QMBS in the PXP model have been studied using a wide variety of techniques that yield several insights into their origin [11, 10, 12, 128, 129, 130, 131], which are reviewed in more detail in Refs. [13, 14]. However, we emphasize that this tower of QMBS in the PXP model [8] or in its deformations with almost perfect revivals [12] are not examples of exact QMBS, and are hence beyond the scope of this review.

5.2.2. Exact QMBS in 1d Beyond the tower of approximate QMBS, exact eigenstates of the 1d PXP model with area-law entanglement and simple MPS expressions were constructed in Ref. [132], which are examples of exact QMBS. Two exact states with

$E = 0$ were obtained for OBC and PBC, whereas two additional exact states with $E = \pm { \sqrt { 2 } }$ were obtained for OBC, which differ from the $E = 0$ exact states at the boundaries. The OBC eigenstates at non-zero energy are certainly in the middle of the energy spectrum and should be considered as examples of QMBS. The case is slightly different for the exact states with $E = 0$ , which are examples of QMBS only if typical eigenstates in the exponentially large zero energy state manifold satisfy ETH, numerical evidence for which was found in Ref. [119]. These exact eigenstates also appear to be base states for variational quasiparticle constructions of the approximate towers of QMBS in the PXP model [132], complementary to other approximations for the tower of QMBS in the PXP models [101, 133]. More examples of such exact eigenstates in PXPlike models were obtained in Refs. [134, 135]. Furthermore, numerical observations in Ref. [135] also suggest that some low-entanglement states similar to the exact states in the PXP model exist within the exponentially large manifold of $E = 0$ eigenstates of all local Hamiltonians with inversion and particle-hole symmetries, although they might not have an MPS form with finite bond-dimension. Finally, we note that Ref. [136] connected these exact states in the PXP model to the Shiraishi-Mori formalism discussed in Sec. 4.1.

5.2.3. Exact QMBS in Higher Dimensions PXP models in higher dimensions also admit exact QMBS eigenstates. Ref. [137] constructed exponentially many exact $E = 0$ “dimerized” eigenstates (similar to the ones in Ref. [125]) in the 2d PXP model on square and rotated-square lattices, which can also be generalized to the 3d PXP model on cubic lattices. As demonstrated there, these eigenstates also have direct implications for dynamics of states on Rydberg arrays. However, since they all have zero energy, they are different from the approximate towers of equally-spaced eigenstates that lead to revivals observed in the deformed 2d PXP model studied in Ref. [138].

# 5.3. Other exact eigenstates

To complete our discussion on exact results on excited states, we briefly survey some examples of exact excited states that are not considered examples of QMBS due to their position in the energy spectrum (i.e., they are typically not in the bulk of the spectrum). However, in many cases we expect that these eigenstates are QMBS of appropriately modified Hamiltonians where such states are “embedded” into the middle of the spectrum following ideas similar to the Shiraishi-Mori formalism discussed in Sec. 4.1.

One class of exact excited states are single quasiparticle excited states above a frustration-free ground state of a Hamiltonian, which have an area-law entanglement [64, 139]. Examples of such eigenstates close to the edges of the spectrum date back to early works in the Majumdar-Ghosh model [140, 141], as well as two exact low-energy excited “Arovas” states in the spin-1 AKLT model [66], which were later generalized to any integer spin- $S$ [15]. More recently, Refs. [102, 133] solved for quasiparticle exact excited states in a frustration-free Hamiltonian modelling Rydberg interactions similar to the PXP model, and Ref. [133] also used the nature of these states to obtain better variational expressions for the approximate towers of QMBS in the PXP model. Similarly, exact expressions for several families of one or two quasiparticle eigenstates close to the ferromagnetic state of certain $S U ( 2 )$ -symmetric models have been obtained. The simplest of these are the well-known spin-waves on top of the ferromagnet, and more involved examples of such states can be found in the spin-1 AKLT model [15]. Finally, we note that examples of quasiparticle states also exist in the literature in higher dimensions, particularly in the $U ( 1 )$ -symmetric XY model (also known as the XX model) on hypercubic lattices [142], and in the Hubbard model on square lattices [143, 144]. These eigenstates have $\mathcal { O } ( L )$ quasiparticles in an $L \times L$ system, and the quasiparticle number density (and hence their energy density) goes to zero in the thermodynamic limit. Hence we do not expect them to be direct examples of QMBS in their respective models.

# 6. Hilbert Space Fragmentation and Krylov Subspaces

Hilbert space fragmentation is a related phenomenon of ergodicity breaking. In this section, we discuss this phenomenon, as well as its similarities and differences with QMBS. Given a quantum system with Hilbert space $\mathcal { H }$ and Hamiltonian $H$ , we can decompose the Hilbert space into dynamically disconnected subspaces, referred to as Krylov subspaces (or sometimes as fragments or subsectors), as follows

$$
\mathcal { H } = \bigoplus _ { j = 1 } ^ { K } \mathcal { K } _ { j } , \quad \mathcal { K } _ { j } = \operatorname { s p a n } _ { t } \{ e ^ { - i H t } | \psi _ { j } \rangle \} ,
$$

where $\mathrm { s p a n } _ { t } \{ e ^ { - i H t } | \psi _ { j } \rangle \} \equiv \mathrm { s p a n } \{ | \psi _ { j } \rangle , H | \psi _ { j } \rangle , H ^ { 2 } | \psi _ { j } \rangle , \cdots , \}$ denotes the subspace spanned by time-evolution of the state $| \psi _ { j } \rangle$ , and $K$ is the number of Krylov subspaces. Note that the $| \psi _ { j } \rangle$ ’s in Eq. (45) are chosen such that the subspaces $\mathcal { K } _ { j }$ ’s are distinct. As discussed in Sec. 2.4, Hilbert space fragmentation referred to the phenomenon where the system possesses exponentially many Krylov subspaces, i.e. $K \sim \exp ( L )$ for a system of size $L$ . The decomposition of Eq. (45) is trivial if $| \psi _ { j } \rangle$ ’s are eigenstates of $H$ , and is expected if the Hamiltonian $H$ possesses certain symmetries such that different $| \psi _ { j } \rangle$ ’s in Eq. (45) have different symmetry quantum numbers. However, the decomposition for fragmented systems is different in two ways. First, $| \psi _ { j } \rangle$ ’s are typically chosen to be product states, usually motivated by their more straightforward experimental preparation. For a non-integrable Hamiltonian, such a choice usually leads the subspace $\mathcal { K } _ { j }$ to be generically the full Hilbert space after resolving symmetries of the system. However, the different Krylov subspaces $\mathcal { K } _ { j }$ in fragmented systems are not distinguished by quantum numbers corresponding to any obvious local symmetries of $H$ . Second, for generic systems with conventional symmetries such as $\mathbb { Z } _ { 2 }$ , $U ( 1 )$ , or $S U ( 2 )$ , the number of Krylov subspaces $K$ either stays constant or grows polynomially with increasing system size, whereas it grows exponentially in fragmented systems [17, 18, 117].

Furthermore, the dimensions of the Krylov subspaces in fragmented systems typically have a wide range, from one-dimensional “frozen” product states where all terms of Hamiltonian act trivially, to subspaces with exponentially large dimension that can be studied in terms of a Krylov-restricted effective Hamiltonian. Fragmentation was explicitly pointed out in the context of dipole-moment or center-of-mass conserving systems [145, 17, 18, 19], although similar phenomena have been discussed in several works [146, 147, 148, 149, 150, 151, 152, 153, 120]. In Sec. 6.1 we discuss a simple example of Hilbert space fragmentation in a dipole-moment conserving system, which illustrates several essential features of fragmented systems. In Secs. 6.2, we survey some other models in the literature that demonstrate fragmentation and comment on some general features of fragmented systems. In Sec. 6.3, we discuss the implications of fragmentation to dynamics and connections to QMBS. Finally, we dedicate Sec. ?? to the discussion of autocorrelation functions, an important diagnostic in the context of fragmentation, and discuss its properties.

# 6.1. Simple example: Pair-hopping model

We start with a simple example of Hilbert space fragmentation that occurs in an interacting model of electrons that conserves the total dipole moment of the system in addition to the total charge. Systems conserving dipole moment or center-of-mass were first discussed in Ref. [154], in the quest to build featureless Mott insulators. They naturally arise in physical systems in two different contexts. First, in quantum Hall effect on a thin cylinder, where the effective Hamiltonian with translation invariant interactions projected onto a single Landau level [148, 155, 120, 156, 157, 158, 151] exhibits dipole moment conservation. Second, they also appear as effective Hamiltonians within resonant subspaces in the interacting Wannier-Stark problem, i.e., interacting fermions hopping on a finite one-dimensional lattice, subject to a strong electric field [159, 160, 19, 161]. Such a system has been probed in many recent experiments [162, 163, 164], and Hilbert space fragmentation is believed to contribute to the observed slow dynamics [161, 165].

6.1.1. Model and symmetries We now illustrate Hilbert space fragmentation in dipolemoment conserving systems with the help of a simple one-dimensional spinless fermionic “pair-hopping model” [154, 120, 19] $H _ { \mathrm { P H } }$ with OBC, which is the “quantum part” (i.e., neglecting electrostatic terms) of the pseudopotential Hamiltonian in the $\nu = 1 / 3$ Fractional Quantum Hall effect [156] in the thin torus limit [156, 120]:

$$
H _ { \mathrm { P H } } = \sum _ { j = 1 } ^ { L - 3 } H _ { j } = \sum _ { j = 1 } ^ { L - 3 } \Big ( c _ { j } ^ { \dag } c _ { j + 3 } ^ { \dag } c _ { j + 2 } c _ { j + 1 } + h . c . \Big ) .
$$

The terms $H _ { j }$ implement the transitions $| 1 \ 0 \ 0 \ 1   | 0 \ 1 \ 1 \ 0 $ , where $\left| a \ b \ c \ d \right.$ denote the occupancies of four consecutive sites on the chain, and the model preserves the

dipole moment (i.e. center-of-mass position) [154], given by the operator

$$
\widehat { D } \equiv \sum _ { j = 1 } ^ { L } j \widehat { n } _ { j } ,
$$

where $\hat { n } _ { j }$ is the fermion number operator on site $j$ .

Given the set of allowed transitions by the terms $\{ H _ { j } \}$ , we can study its dynamically disconnected Krylov subspaces $\{ \mathcal { K } _ { j } \}$ of Eq. (45). We are only interested in the dynamics of initial product states, which are more easily accessible to experiments, and hence we consider Krylov subspaces $\boldsymbol { { \cal { K } } } _ { j }$ generated by product states $| \psi _ { j } \rangle$ . Although we will only consider the translation invariant model of Eq. (46), note that the Krylov subspaces we study only depend on the structure of the transitions of $\{ H _ { j } \}$ , hence the Krylov subspaces of the entire family of models of the form $\textstyle \sum _ { j } J _ { j } H _ { j }$ for arbitrary couplings $J _ { j }$ are the same.

6.1.2. Frozen configurations and small Krylov subspaces Exponentially many of these Krylov subspaces are one-dimensional frozen configurations—product states that are eigenstates of $H$ . This is a direct consequence of the “sparsity” of transitions that the terms $\{ H _ { j } \}$ implement, i.e. the Hamiltonian vanishes on any product state not containing the patterns “ $\cdots 0 1 1 0 \cdots$ ” or $\cdots 1 0 0 1 \cdots$ ” on four consecutive sites. Since there are exponentially many such patterns, there are equally many one-dimensional Krylov subspaces. Further, Krylov subspaces can be constructed by embedding finite active blocks, i.e. regions where the Hamiltonian acts non-trivially, into any frozen configuration, thereby leading to exponentially many Krylov subspaces with dimension of $\mathcal { O } ( 1 )$ [17, 18]. For example, the following configurations $| \psi _ { \pm } \rangle$

$$
{ \begin{array} { l } { \displaystyle | \psi _ { \pm } \rangle = { \frac { 1 } { \sqrt { 2 } } } \left( \left| 1 1 1 0 0 0 \cdots 1 1 0 0 0 { \overline { { [ 1 0 0 1 ] } } } 1 1 1 0 0 0 \cdots 1 1 1 0 0 0 \right. \right. } \\ { \displaystyle \left. \pm \left| 1 1 1 0 0 0 \cdots 1 1 1 0 0 0 { \overline { { [ 0 1 1 0 ] } } } 1 1 1 0 0 0 \cdots 1 1 1 0 0 0 \right. \right) } \end{array} } 
$$

are composed of one active block (boxed) sandwiched between frozen configurations, and they span a two-dimensional Krylov subspace. The presence of exponentially many frozen states and states with frozen regions within each symmetry sector in the Hilbert space has direct implications to the dynamics of such systems: time-evolution starting from a random product state looks very different from the behavior expected for typical thermal non-integrable models.

6.1.3. Exponentially large Krylov subspaces Apart from frozen configurations and Krylov subspaces of small dimension, the pair-hopping model also exhibits Krylov subspaces with exponentially large dimensions that scale with system-size as $\sim \alpha ^ { L }$ as $L \to \infty$ and $1 < \alpha < 2$ . As discussed in Ref. [19], these subspaces can be highly nonlocally constrained, and certain Krylov subspaces in $H _ { \mathrm { P H } }$ are characterized by a certain non-local string order. Furthermore, the properties of these subspaces can be vastly different, demonstrating the rich dynamical structure inherent to systems with Hilbert space fragmentation. For example, the Hamiltonian restricted to a given subspace can be either integrable or non-integrable (either satisfying a restricted form of ETH or MBL), and subspaces of different types can coexist. We now provide one example of an integrable Krylov subspace with exponentially large dimension in the pair-hopping model $H _ { \mathrm { P H } }$ of Eq. (46) via a spin mapping demonstrated in Refs. [147, 148, 155, 19]. The Hamiltonian $H _ { \mathrm { P H } }$ with even system size $L = 2 N$ has an additional symmetry: sublattice particle number conservation [19], and we group sites $2 j - 1$ , $2 j$ of the original lattice into a new site $j$ so as to form a new chain with $N = L / 2$ sites. It is convenient to work in terms of new degrees of freedom for these composite sites defined as $\left| \uparrow \right. \equiv \left| 0 1 \right.$ $\left| \downarrow \right. \equiv \left| 1 0 \right.$ . The action of the terms $H _ { j }$ of Eq. (46), when written in terms of the composite spins, is simply given by ${ \biggl | } [ { \overline { { [ 0 1 ] } } } { \overline { { [ 1 0 ] } } }   { \biggl | } [ { \overline { { 1 0 } } } { \biggr | } { \overline { { [ 0 1 ] } } }   | { \uparrow } { \downarrow } \rangle  | { \downarrow } { \uparrow } \rangle$ . Hence for any Krylov subspace generated by a product state $| \psi _ { 0 } \rangle$ with only composite spin degrees of freedom $\uparrow$ and $\downarrow$ , the action of the Hamiltonian restricted to the Krylov subspace interchanges the spins, and hence exactly maps onto a spin- $1 / 2$ XX model:

$$
H _ { X X } \left[ N \right] \equiv \sum _ { j = 1 } ^ { N } \left( \sigma _ { j } ^ { + } \sigma _ { j + 1 } ^ { - } + \sigma _ { j } ^ { - } \sigma _ { j + 1 } ^ { + } \right) ,
$$

where $\big \{ \sigma _ { j } ^ { + } \big \}$ and $\big \{ \sigma _ { j } ^ { - } \big \}$ are Pauli matrices on site $j$ . As is well known, the Hamiltonian Eq. (49) can be solved using a Jordan-Wigner transformation [166], upon which it maps onto a non-interacting fermion problem. However, as can be readily shown, these are not the only states within the same charge and dipole moment sector, providing evidence for Hilbert space fragmentation in the pair-hopping Hamiltonian $H _ { \mathrm { P H } }$ .

6.1.4. Krylov subspaces due to blockades Additional integrable or non-integrable Krylov subspaces can be systematically constructed by inserting blockades in the system, i.e., frozen configurations on a part of the system that remain unchanged under the action of the Hamiltonian. For example, consider Krylov subspaces generated by product states of the $\left| \cdots 1 1 1 \cdots \right.$ or $| \cdots \cdot 0 0 0 \cdots \rangle$ , where $\cdot \cdot \cdot$ denotes active regions where the terms $\{ H _ { j } \}$ of $H _ { \mathrm { P H } }$ act non-trivially. Configurations such as 111 or 000 embedded in the middle of the chain do not change under the action of the local terms $H _ { j }$ . Hence they can be used to separate active regions of the chain, leading to exponentially many new Krylov subspaces. The Hamiltonian restricted to such Krylov subspaces with multiple active regions separated by blockades is simply the sum of commuting terms that act on different active regions of the chain.

6.1.5. Strong $v / s$ weak fragmentation In addition to the “‘minimal-range” dipole conserving model of Eq. (46), we can introduce longer-range dipole moment conserving terms such as $\left( c _ { j } ^ { \dagger } c _ { j + 5 } ^ { \dagger } c _ { j + 1 } c _ { j + 4 } + h . c . \right)$ , which connect several of the Krylov subspaces of the minimal-range model [17, 19]. Nevertheless, Refs. [17, 18] showed that Hamiltonians with dipole moment conservation and terms of any finite range is guaranteed to exhibit

Hilbert space fragmentation. A simple proof relies on building exponentially many frozen patterns that are annihilated by dipole moment conserving terms of any finite range. For example, states of the form $| 0 \cdot \cdot \cdot 0 1 \cdot \cdot \cdot 1 0 \cdot \cdot \cdot 0 1 \cdot \cdot \cdot 1 \rangle$ , where $0 \cdot \cdot \cdot 0$ and $1 \cdot \cdot \cdot 1$ are clusters of at least $m$ sites with identical occupation, are frozen under the action of any dipole conserving term acting on less than or equal to $m$ consecutive sites. However, as discussed in Ref. [17], adding longer range terms to the minimal dipole conserving model changes the nature of fragmentation in the system from “strong” to “weak”, which are defined as follows. Referring to the dimension of the largest Krylov subspace as $D _ { \operatorname* { m a x } } = \operatorname* { m a x } _ { j } \{ \dim ( K _ { j } ) \}$ , and full Hilbert space dimension (after resolving all conventional symmetries) as $D$ , Ref. [17] classified fragmented systems into two types: strongly fragmented when $D _ { \mathrm { m a x } } / D ~  ~ 0$ and weakly fragmented when $D _ { \operatorname* { m a x } } / D \to 1$ respectively in the thermodynamic limit. Note that these notions of strong and weak fragmentation only apply within usual (e.g., charge and dipole) symmetry sectors [117]. Indeed, Ref. [167] provided an example of a dipole moment conserving Hamiltonian that exhibits strong fragmentation within certain quantum number sectors while exhibiting weak fragmentation in other sectors.

# 6.2. Survey of other examples in the literature

We now survey several other examples of Hilbert space fragmentation in the literature, including those that do not involve dipole moment conserving models.

6.2.1. Spin-1 Dipole Conserving Model Apart from dipole conserving systems of spinless fermions that we have discussed in Sec. 6.1, spin-1 dipole conserving model, given by the Hamiltonian

$$
H _ { 3 } \equiv \sum _ { j } ( S _ { j - 1 } ^ { - } ( S _ { j } ^ { + } ) ^ { 2 } S _ { j + 1 } ^ { - } + \mathit { h . c . } ) ,
$$

where $S _ { j } ^ { \pm }$ ’s are the spin-1 raising and lowering operators on site $j$ . This Hamiltonian, and its Floquet version, have been studied in detail in Refs. [145, 17, 18, 168]. They show that the model possesses several similar features as $H _ { \mathrm { P H } }$ , i.e., it hosts exponentially many frozen eigenstates and Krylov subspaces, most of which feature blockades, as well as exponentially large non-locally constrained Krylov subspaces. As shown in Ref. [168], the model also exhibits integrable subspaces that map onto spin- $1 / 2$ XX models. While the minimal spin-1 dipole conserving model exhibits strong fragmentation in all charge and dipole quantum number sectors, longer range spin-1 dipole-conserving model were numerically observed to exhibit weak fragmentation [17] in the largest quantum number sector. However, Ref. [167] observed a “freezing transition” from weak to strong fragmentation as a function of filling factor (i.e., charge quantum number) in the longer range spin-1 dipole-conserving systems with three and four site terms.

6.2.2. $t - J _ { z }$ Model A simple example is the $t - J _ { z }$ model in one dimension, which appears in the large- $U$ limit of the Hubbard model [169, 170]. The model describes the nearest-neighboring hopping of spin- $1 / 2$ fermions on a chain, within the constrained Hilbert space that forbids a double occupancy of sites. Denoting spins by $\sigma \in \{ \uparrow , \downarrow \}$ and the corresponding fermion creation and annihilation operators by $c _ { j , \sigma } ^ { \dag }$ and $c _ { j , \sigma }$ , the explicit Hamiltonian in one dimension can be expressed in terms of constrained fermion operators $\tilde { c } _ { j , \sigma } \equiv c _ { j , \sigma } ( 1 - c _ { j , - \sigma } ^ { \dag } c _ { j , - \sigma } )$ as [168]

$$
H _ { t - J _ { z } } \equiv \sum _ { j } [ - t _ { j } \sum _ { \sigma \in \{ \uparrow , \downarrow \} } \left( \tilde { c } _ { j , \sigma } \tilde { c } _ { j + 1 , \sigma } ^ { \dagger } + h . c . \right) + J _ { j } ^ { z } S _ { j } ^ { z } S _ { j + 1 } ^ { z } ] ,
$$

where $t _ { j }$ , $J _ { j } ^ { z }$ are arbitrary constants, $S _ { j } ^ { z } = ( \tilde { c } _ { j , \uparrow } ^ { \dag } \tilde { c } _ { j , \uparrow } - \tilde { c } _ { j , \downarrow } ^ { \dag } \tilde { c } _ { j , \downarrow } )$ , and $\bar { c } _ { j , \sigma }$ . In other words, denoting the fermions by $\uparrow$ and $\downarrow$ and vacant sites by $0$ , the Hamiltonian only allows the transitions $| \uparrow 0   | 0 \uparrow $ and $| \downarrow 0   | 0 \downarrow $ . Given these transitions, it is easy to show that the $t - J _ { z }$ model is fragmented in one dimension. Since an $\uparrow$ cannot cross over a $\downarrow$ and vice-versa, the full pattern of fermion spins along the chain is conserved [168], resulting in exponentially many dynamically disconnected Krylov subspaces that appear within quantum number sectors labelled by the total numbers of $\uparrow$ and $\downarrow$ fermions, the two $U ( 1 )$ symmetries of the system.

6.2.3. Miscellaneous Examples Other notable examples of fragmentation typically appear in the presence of hard constraints that naturally arise in effective Hamiltonians obtained by a truncation of the Schrieffer-Wolff transformation [171] in the presence of a large parameter, e.g. the dipole-conserving models in the presence of a large electric field. For example, fragmentation similar to that in the $t - J _ { z }$ model also occurs in the $t \mathrm { ~ - ~ } V$ model in the strong coupling regime, which is illustrated in Ref. [172]. Other such examples include certain one-dimensional models with strict confinement [173, 126, 174], where the Hamiltonian restricted to a Krylov subspace was shown to be the integrable XXZ model, models within the Fibonacci Hilbert space of the Rydberg blockade [175, 176], in the presence of frustration [177, 178] or dipolar interactions [179]. In addition, several one-dimensional models introduced in earlier literature in various contexts have been shown to exhibit fragmentation, including the Fredkin [180], Motzkin [181], Pair-Flip [117], folded XXZ [20, 182, 183, 184], and Temperley-Lieb spin chains [185, 117]. While most examples of fragmentation are in the product state basis, Ref. [117] recently showed that one-dimensional models based on the Temperley-Lieb algebra, including the spin-1 biquadratic spin chains, are fragmented in an entangled basis constructed using spin singlets.

6.2.4. Higher Dimensional Systems Relatively fewer models are known to exhibit fragmentation in dimensions higher than 1. Several models that are fragmented in one dimension, for example the $t - J _ { z }$ model of Eq. (51), are no longer fragmented in higher dimensions [117]. Nevertheless, Ref. [18] argued that the conservation of dipole moment in all directions on hypercubic lattices is sufficient to guarantee the existence of exponentially many frozen eigenstates. In addition, they showed that the conservation of dipole and quadrupole moments in two dimensions is sufficient for the existence of several other features of fragmentation, including blockades that dynamically disconnect different parts of the system. Meanwhile Ref. [186] studied fragmentation in two-dimensional ring-exchange models, which in addition to conserving dipole and quadrupole moments, also possess certain subsystem symmetries.

6.2.5. General features of fragmented systems We now comment on a few general features that occur in fragmented systems. However, note that the nature and consequences of fragmentation differ from model to model, and so far there is no universally accepted defining feature of fragmentation (see Ref. [117] for a proposed definition). Three common features of systems exhibiting fragmentation are: (i) Multiple types of Krylov subspaces where all parts of the system are “active”, (ii) Exponentially many product states that are completely frozen, (iii) Frozen regions that lead to blockades in the system that effectively disconnect “active” regions of the system. As discussed in Sec. 6.1, the dipole-conserving systems possess all three features. Other examples of fragmentation in the literature typically possess some of these features, although not necessarily all of them. For example, several models discussed in the previous paragraph, including the $t - J _ { z }$ model, do not possess feature (iii), i.e., it is not possible to construct frozen regions that disconnect regions of the system. On the other hand, the PXP model discussed in Sec. 5.2, from the point of view of the full spin- $1 / 2$ Hilbert space, can possess nearest-neighboring excitations $| \cdots \uparrow \uparrow \cdots \rangle$ that are examples of “frozen regions” unaffected by the action of the Hamiltonian of Eq. (44). These frozen regions dynamically disconnect different parts of the system, leading to exponentially many Krylov subspaces; $\parallel$ hence the PXP model is a trivial example of fragmentation that only possesses feature (iii).

# 6.3. Implications to dynamics and connections to QMBS

From the perspective of the full Hilbert space $\mathcal { H }$ after resolving quantum numbers of all the conventional symmetries, fragmented systems violate either strong ETH or weak (and hence also strong) ETH [17, 18], giving rise to richer physics than QMBS.

6.3.1. Strong Fragmentation Strongly fragmented systems, depicted in Fig. 1b, do not have a dominant Krylov subspace in the thermodynamic limit (i.e., $D _ { \mathrm { m a x } } / D  0$ as $L \to \infty$ ), and hence violate the conventional form of weak ETH (w.r.t. the full Hilbert space) in addition to strong ETH. In contrast to examples of QMBS, typical initial states in strongly fragmented systems do not thermalize with respect to the full Hilbert space.

The absence of conventional thermalization can be understood in terms of the EE of eigenstates. As discussed in Sec. 2.3, in the absence of fragmentation, the bipartite $\parallel$ The experimentally relevant Krylov subspace among these is the Fibonacci Hilbert space, the one without any nearest-neighbor excitations, which is the focus of studies on the PXP model [13].

![](images/70669c04b69fea22ae47c00b61b71720e4e0e005ba48955b3845bf3820fd27cb.jpg)  
Figure 9. (Color online) Figure reproduced from Ref. [173] showing the bipartite entanglement entropy (EE) of eigenstates in a system exhibiting strong Hilbert space eigenstates w. (a) Entangfragmentation. (a) $\mathrm { E E }$ in the    ment entropy of the eigenstates within the as a function of energy in a particular quantum number sector uibipartitioning of tspecified by the total spin $S ^ { z }$ an emergentand domain wall number $n _ { D W }$ sector built fro. The wide distribution zð DW of the $\mathrm { E E }$ 0 11111100000¼ 8 ¼ −2Þ    at a particular energy is in stark contrast to $\mathrm { E E }$ 10101010101 0 fo   of eigenstates in typical Þ   . Red line, Page value of the n ; Sz sector; green line,non-integrable models. (b) EE of eigenstates within a particular Krylov subspace of ctor. (b) Entanglement     the fragmented model. This plot resembles the behavior of the EE within a quantum value) after a quantum glement      number sector of typical non-integrable models.

EE of a typical eigenstate is given by $S _ { \mathrm { t h } }$ of Eq. (9) for spin- $1 / 2$ ¼ 26      systems. In the presence integrable. Red lines mark of fragmentation, the EE of eigenstates that belong to the Krylov subspace $\boldsymbol { \mathcal { K } } _ { j }$ e Page about a low mobilesubsystem with $L _ { \mathcal { A } } \leq L / 2$ ons to be subsect spins is upper bounded by $\sim \log \left( D _ { K _ { j } } \left[ L _ { A } \right] \right)$ , where $D _ { K _ { j } } \left[ L _ { A } \right]$ Whereas these modelsis the dimension of the Krylov subspace $\boldsymbol { \mathcal { K } } _ { j }$ low mobile excitationsrestricted to the subsystem of size $L _ { A }$ be, similar to the EE in constrained systems [42, 187]. Similar bounds hold for the EE of a late-time state obtained by time evolution of product states $| \psi _ { j } \rangle$ within a Krylov subspace $\boldsymbol { \mathcal { K } } _ { j }$ . In ile magnon can propagate all the exact formula: k n 1ð1=kÞ           a Krylov subspace whose dimension restricted to a subsystem grows exponentially with e system. Therefore, the model m min D ; D , and n maxmodel (1): an isolated mobile magnon can propagate all thesubsystem size, this could still result in a volume-law behavior, although with a smaller lly separated thermal and nway to the boundarycoefficient. For example, in a spin- $1 / 2$ in Fig. 2(a) (green dashed linhe system. Therefore, the model fragmented system and a Krylov subspace $\mathcal { K } _ { j }$ actonwhere $D _ { K _ { j } } [ L _ { A } ] \sim \phi ^ { L _ { A } }$ o [for $1 < \phi < 2$ ]., the EE is bounded by $S \le L _ { A } \log \phi < L _ { A } \log 2$ . On the other hand, the entanglement entropy for product states that are part of $\mathcal { O } ( 1 )$ - dimensional Krylov subspaces cannot exceed a constant value, resulting in a more Using this fact, one can then prove [40] that any configu-apparent breakdown of thermalization. Moreover, in fragmented systems that exhibit agnons to the right boundary Testing this scenario numericallration that is not frozen can be brought into the form (2) byblockades discussed in Sec. 6.2.5, randomly chosen product states typically consist of ny connected subsector can be sizes with bigger subsector dregions that are frozen under the action of the Hamiltonian, which could lead to a further k-magnon state. armed with the knowledge of thebreakdown of thermalization. For example, the entanglement entropy of all eigenstates n and integrability.—The frac- one can directly construct the p        within a Krylov subspace with a blockaded region is zero if the bipartition cut is within built from an appropriate k-magnon state.the blockaded region. This variety of Krylov subspaces in fragmented models gives rise Subsector thermalization and integrability.—The frac-to a large variance of the EE of eigenstates even within a conventional quantum number turing of the Hilbert space into exponentially many dis-sectors, e.g. as shown in Fig. 9a. However, this variance is small for eigenstates within olate ETH, as can be diagnoseda Krylov subspace, as shown in Fig. 9b.

y. In Fig. 2(a), we plot the 0 111111000000 010101010101 0      The existence of large Krylov subspaces, even after resolving conventional symmetry e eigenstates within an n ; Sz eigenstate entanglement entropyHamiltonian (1) strongly violate ETH, as can be diagnosedquantum numbers, also has direct implications for the level statistics and ETH in systems that exhibit strong fragmentation. For example, an evident lack of level repulsion is observed between energy levels that belong to different Krylov subspaces, hence systems with strong fragmentation exhibit Poisson level statistics even after resolving conventional symmetry quantum numbers. In addition, since the eigenstates in different Krylov subspaces are “uncorrelated”, diagonal ETH is generically violated. In particular, the eigenstate expectation values of local operators are not smooth functions of energy even within a given quantum number sector of conventional symmetry, e.g., as shown for the $t - J _ { z }$ model is shown in Fig. 10a. This should be contrasted with the situation for typical non-integrable models, where the eigenstate expectation values of local operators are given by the thermal value at that energy, up to finite-size corrections (see Eq. (6)). This is also different from models with QMBS, where diagonal ETH is satisfied in almost all eigenstates, apart from a small set of QMBS eigenstates, e.g., as shown in Fig. 8.

6.3.2. Weak fragmentation Unlike strongly fragmented systems, weakly fragmented ones have a single dominant non-integrable Krylov subspace and its dimension approaches the dimension of the full Hilbert space in the thermodynamic limit (i.e, $D _ { \operatorname* { m a x } } / D ~  ~ 1$ as $L \ \to \ \infty$ ). Hence, while they violate strong ETH due to frozen eigenstates and $\mathcal { O } ( 1 )$ -dimensional Krylov subspaces, they generically satisfy weak ETH as a consequence of the dominant block. Thus, typical initial states thermalize with respect to the full Hilbert space in weakly fragmented systems, although particular initial states that have large weight on the small Krylov subspaces do not thermalize. This is also evident from conventional diagnostics such as the energy level statistics and entanglement entropy in weakly fragmented systems, which obey the same behavior as models with QMBS, summarized in Tab. 1. Indeed, weakly fragmented systems share a lot of their phenomenology with QMBS depicted in Fig. 1a, and the exponentially many eigenstates that do not belong to the dominant Krylov subspace should be considered examples of QMBS, according to the definitions discussed in Sec. 2.4. Most of these eigenstates are generically not equally spaced in energy, hence they are examples of isolated QMBS discussed in Sec. 5 as opposed to towers of QMBS discussed in Sec. 3. $\ P$

6.3.3. Krylov-Restricted Thermalization In spite of ETH violation with respect to the full Hilbert space in fragmented systems, expectation values of local operators within eigenstates of sufficiently large (with dimension $\mathcal { D } _ { \kappa } [ L ] \to \infty$ as $L \to \infty$ ) Krylov subspaces $\mathcal { K } _ { j }$ do show signatures of ETH, even in strongly fragmented systems. This phenomenon was referred to as Krylov-Restricted Thermalization in Ref. [19], and evidence for its validity has been found in various fragmented systems [19, 120, 173, 178].

$\Lsh$ Note that as demonstrated in Refs. [172, 89, 188], it is possible to construct equally spaced eigenstates in some fragmented systems, particularly if the system can possess blockades. The existence of such eigenstates leads to revivals from particular initial states, giving rise to phenomenology of towers of QMBS in some fragmented systems. However, this is not generically the case.

![](images/057ca6609b56d3e165c83bc83be7aa9cadb6208622156d2f4d1bb0036ff7478f.jpg)  
matrix elements in the t J model.Figure 10. (Color online) ETH in fragmented systems. (a) Figure reproduced from of the average nearest neighbor antifer-Ref. [168] showing the expectation value of a certain local operator within eigenstates of onsthe $t - J _ { z }$ enstates of Ht J with globalmodel of Eq. (51). The large variance in the distribution of the expectation NF = L/2 and P Szj = 0, and openvalues at a particular energy is in stark contrast to behaviour expected in generic s. For the system sizes shown (L =non-integrable models. (b) Figure reproduced from Ref. [19] showing the infiniteution becomes wider with increasing sys-temperature thermalization of the charge density within a Krylov subspace of the mptotically it is expected to npair-hopping model of Eq. (46).

In strongly fragmented systems, the Krylov-Restricted Thermalization within the nonlocally constrained Krylov subspaces $\mathcal { K } _ { j }$ can lead to many surprising consequences, ectively), which is quantum integrable. Most of theincluding atypical late-time expectation values of local operators [19, 178], and an er sectors, on the other hand, show random matrixapparent Casimir effect [189]. For example, the infinite-temperature charge density l statistics, signalling quantum chaotic behavior. Theprofile within a Krylov subspace of the pair-hopping model of Eq. (46) has been shown ken by additiin Fig. 10b.

asis (e.g. a staggered field). These commute withWhile Krylov-Restricted ETH is novel, Refs. [172, 62] also showed the existence he SLIOMs, and therefore do not change our conclu-of an ETH-MBL transition within certain non-integrable Krylov subspaces of a spin1/2 dipole conserving model, which should constitute a novel form of non-locally constrained MBL in fragmented systems that might be different from locally constrained MBL [190, 191]. In addition, Ref. [174] found the emergence of ballistic transport and phenomenology associated with integrable systems, in a fragmented model possessing is worthwhile to consider separatelysome integrable Krylov subspaces.

in. In this case k does not scale with the system size6.3.4. Labelling Krylov Subspaces The results on Krylov-restricted thermalization Haar   show that large enough Krylov subspaces in fragmented systems closely resemble an observable near the boundary has finite overlapquantum number sectors corresponding to conventional symmetries, and calls for a h these SLIOMs and, under time evolution, a non-characterization of Krylov subspaces in the same language as conventional symmetries. ishing fraction of it would remain localized in a finiteSuch a question was first explored in Ref. [168], where operators referred to as “Statistically Localized Integrals of Motion” (SLIOMs) were introduced for the $t - J _ { z }$ h L, one finds that it remains finite in the limit Lmodel and the minimal-range spin-1 dipole moment conserving model with OBC. The bound is largest at the boundary, j = 1, where itRemarkably, the full set of eigenvalues under all the SLIOMs uniquely label the es the value 4/9, and decays away from the boundary1/2Krylov subspaces. However, unlike operators corresponding to conventional symmetries, these SLIOMs are highly non-local operators, although they are “localized” in a sense defined in Ref. [168] and can be used to explain the anomalous late-time behavior of autocorrelation functions [168, 117]. In particular, for certain models of fragmentation, the existence of SLIOMs implies boundary localization and analogues of strong zero modes [192, 193, 194] for non-integrable models. Apart from the $t - J _ { z }$ model, the SLIOMs have also proved useful in explaining dynamical phenomena in other models of fragmentation, e.g., in the context of dimer models [195].

While it is not clear if SLIOMs can be constructed in all examples of fragmentation, more recently, Ref. [117] approached the question of labelling Krylov subspaces using the language of so-called “commutant algebras”, which generalizes the notion of the symmetry algebra for systems with conventional symmetries. In particular, the commutant algebra is defined for a family of systems (e.g. for $\{ \sum _ { j } J _ { j } H _ { j } \}$ in the case of the pair-hopping model of Eq. (46), and it is the algebra of operators that commute with that family. Equivalently, it is the algebra of all operators that commute with each term of the Hamiltonian, e.g. with all the $H _ { j }$ in the pair-hopping model. Ref. [117] showed that the irreducible representations of this commutant algebra uniquely define the Krylov subspaces corresponding to a family of systems. Further, the algebra also contains all the local and non-local conserved quantities of that family of systems, including the SLIOMs, which uniquely label the Krylov subspaces. Ref. [117] full commutant algebras and the corresponding Krylov subspaces were explicitly constructed for several fragmented models, including systems where the definition of SLIOMs is not straightforward.

Finally, we note that fragmentation in certain models occurs due to the presence of strictly localized integrals of motion, i.e., operators with support on a small number of consecutive sites. For example, in the PXP model discussed in Sec. 6.2.5, the projector |↑↑i h↑↑| onto a nearest-neighbor configuration with excited Rydberg atoms is a strictly local conserved quantity. Such conserved quantities are analogous to Local Integrals of Motion (LIOMs) that occur in systems exhibiting many-body localization [3]. Such examples were recently referred to as “local fragmentation” in Ref. [196], and it is then straightforward to label the Krylov subspaces using the LIOMs. This systems should be contrasted with systems such as dipole conserving models, that exhibit “true fragmentation”, where it is not clear if strictly local conserved quantities exist.

# 6.4. Autocorrelation Functions

Similar to QMBS, some of the key diagnostics used in the literature to identify Hilbert space fragmentation are the bipartite EE, the energy level statistics, and the expectation values of local operators in eigenstates to test ETH, diagnostics discussed in Sec. 2. In addition to these conventional measures, operator spreading (or lack thereof) has played a key role in diagnosing and understanding fragmented systems [145]. In particular, the spreading of a local operator can be characterized by its autocorrelation function, and we discuss its properties below.

![](images/663c07cc8aaf7f9d9185aab9e2c3a2d4f7a878a725f137bf39a7ea2e9d792ad8.jpg)  
be-Figure 11. (Color online) Figure reproduced from Ref. [17] showing the val-autocorrelation function of the local spin operator in a spin-1 dipole-momentoofconserving system exhibiting strong (red) and weak (blue) fragmentation for several eensystem sizes $N$ . While autocorrelation functions of local operators in generic nonhisintegrable systems are expected to decay to zero at large times for system sizes , the strongly fragmented dipole-conserving Hamiltonian $H _ { 3 }$ of Eq. (50).

both of which avoid correlation function. Panel (a) shows the auto-correlationz z z6.4.1. Definition and Properties The infinite-temperature autocorrelation function of ely many conserveda local operator $\widehat { O }$ nite temperature for N = 13 ( under the Hamiltonian $H$ nsparent curves)is defined as

$$
A _ { L } ( t ) \equiv \langle \widehat { O } ( t ) \widehat { O } ( 0 ) \rangle = \frac { 1 } { D } \mathrm { T r } ( e ^ { i H t } \widehat { O } e ^ { - i H t } \widehat { O } ) ,
$$

e possibiwhere $D$ y of sys-       correlator Sz (t)Sz (0) for H andis the Hilbert space dimension and $L$ + H respectively.is the system size. The behavior of articular we can dis-autocorrelation functions of local operators, both as a function of time and system size, TH: the former sayscontain a lot of information about the system, including its symmetries and the nature of thermal in the thermodynamic limit, while the latter al-transport. In the infinite-time limit, the saturation value of the autocorrelation function, long as their ratio is vanishingly small aor more precisely the infinite-time average defined as $\begin{array} { r } { \bar { \mathcal { A } } _ { L } \equiv \operatorname* { l i m } _ { T  \infty } \frac { 1 } { T } \int _ { 0 } ^ { T } d t \mathcal { A } _ { L } ( t ) } \end{array}$ , is ergy [31–33]. It is important to stressan indicator of the symmetries of the Hamiltonian $H$ hat if only weak. Indeed, the Mazur bound that ETH is sprovides a lower bound on $A _ { L }$ fied, then we can always find initial condi-is stated in terms of the overlap of the operator $\widehat { O }$ on the various conserved quantities of the system [197, 198, 199, 168, 117], and this bound is generically saturated. For example, in a system with $U ( 1 )$ charge conservation, $\boldsymbol { \mathcal { A } } _ { L }$ is expected to decay with system size as $\mathcal { A } _ { L } \sim 1 / L$ , a scaling that can be understood in terms of Mazur bounds [168, 117]. In the infinite-size limit, where the quantity of interest is $\begin{array} { r } { \mathcal { A } _ { \infty } ( t ) \equiv \operatorname* { l i m } _ { L  \infty } \mathcal { A } _ { L } ( t ) } \end{array}$ , the decay of the autocorrelation function with time reveals the nature of transport in the system. For example, in diffusive systems, this autocorrelation function in the thermodynamic limit is expected to decays with time $\mathcal { A } _ { \infty } ( t ) \sim 1 / \sqrt { t }$ , which also forms a numerical diagnostic of the nature of transport in the system. Similarly, the system is said to be subdiffusive if $\mathcal { A } _ { \infty } ( t ) \sim 1 / t ^ { \beta }$ for $\beta < 1 / 2$ , which is observed in several constrained systems, including ones that conserve dipole moment [200, 167, 201, 202, 203]. Below we discuss some of aspects of these diagnostics in fragmented systems.

6.4.2. Strong Fragmentation Strong fragmentation is also usually associated with an anomalous saturation of the infinite-time autocorrelation function $\boldsymbol { \mathcal { A } } _ { L }$ of local operators as a function of system size. For example, strongly fragmented dipole-moment conserving systems, e.g., the pair-hopping model of Eq. (46) or the spin-1 model of

Eq. (50), are known to exhibit “operator localization” [145]. That is, when $\widehat { O }$ is chosen to be a strictly local operator on a site $j$ , the weight the time-evolved operator on the original site $j$ is finite even at infinite times, which is reflected in the finite value of $\boldsymbol { \mathcal { A } } _ { L }$ even in the the thermodynamic limit, e.g., as shown in the red curve in Fig. 11. This is contrast to systems with conventional symmetries, where local operators are expected to spread uniformly throughout the system at late times, and $\boldsymbol { \mathcal { A } } _ { L }$ is expected to decay with system size. This operator localization in dipole-conserving systems can be understood to be a consequence of the abundance of Krylov subspaces with blockades [168, 117], closely related to strong fragmentation. Similar effects are also observed in the autocorrelation functions of local operators in the $t - J _ { z }$ model [168, 117], where certain operators on the boundary are localized. In addition, the autocorrelation functions of local operators in the bulk exhibit a decay of $\bar { \mathcal { A } } _ { L } \sim 1 / \sqrt { L }$ , whereas a decay of $\mathcal { A } _ { L } \sim 1 / L$ is expected from conventional symmetry considerations.

6.4.3. Weak fragmentation In addition, unlike strongly fragmented systems, the effect of weak fragmentation can safely be ignored in the context of infinite-temperature properties of the system, e.g., in the autocorrelation functions $A _ { L } ( t )$ of local operators. This is the case in dipole-moment conserving systems, for example, where there has been a large interest in its sub-diffusive transport at infinite-temperature [200, 162, 204, 203]. Even though dipole-moment conserving systems with finite-range terms are always fragmented, the fragmentation is weak beyond a certain range (e.g., in the pairhopping model discussed in Sec. 6.1) and the autocorrelation functions of local operators decay as $\bar { \mathcal { A } } _ { \infty } ( t ) \sim 1 / t ^ { \frac { 1 } { 4 } }$ , which can be understood without taking fragmentation into consideration. Furthermore, the infinite-time autocorrelation function $A _ { L }$ also decays with system-size, e.g., as shown in the blue curve in Fig. 11, indicating the absence of operator localization. This distinction in the behavior of autocorrelation functions (as well as out-of-time-ordered correlation functions (OTOCs)) between strongly and weakly fragmentated systems has also been used to study the “freezing transition” from weak to strong fragmentation [167, 205].

# 7. Discussion and Outlook

Despite being a relatively new field, QMBS has already attracted a large attention as exemplified in this review. Nevertheless, several major open questions remain, and we summarize a few of those in the following.

Unified framework for QMBS An immediate question is the development of a unified language to describe and understand known examples of QMBS, which might lead to a finer classifications of QMBS. As discussed in Sec. 4, some progress in this direction has been made with the introduction of embedding, SGA-based, and symmetry-based formalisms to explain several examples of towers of QMBS. However, the precise relations between the various formalisms are not yet clear. Several examples of towers have logarithmic scaling of entanglement entropy, S / ln N. However, the entropy of exact eigenstates behaved noof QMBS discussed in Sec. 3.2, including the QMBS in the spin-1 AKLT model, fall monotonically as a function of N, which was attributed to “accidental hybridizations” with nearby eigenstates whooutside the Shiraishi-Mori (SM) embedding and symmetry-based formalisms. On the the PXP model also suppresses the mixing with volume law states, at least up to the largest sizes accessible in exother hand, unlike the embedding and symmetry-based formalisms, the SGA-based S ln N, without volume law corrections.formalisms lack a precise prescription for constructing models with QMBS. Furthermore, many examples have not been explicitly shown to be captured by any of the formalisms, for example the second tower of QMBS in the spin-1 XY model [81, 86], which are not expressed as a repeated action of a raising operator on a simple eigenstate. For isolated examples of QMBS discussed in Sec. 5, the SM formalism captures several examples in the literature, although the connection is not always immediately apparent. Yet there are examples of isolated QMBS such as the exact eigenstates in 2d and higher-dimensional PXP models discussed in Sec. 5.2 that are yet to be understood in this approach. A better understanding of the QMBS formalisms will also help extend examples of QMBS, many of which are restricted to one-dimensional systems, to higher dimensions. Moreover, higher dimensions might also reveal qualitatively different types of QMBS, such as the exponentially many QMBS in the 2D PXP model discussed in Sec. 5.2, which have no 1D counterparts.

![](images/7fa30c9bf2c66de9329ffd6147a1c9cc3221b0e10fcff58b35a5f5e1010299a7.jpg)  
Overlap of all eigenstates with the Z2 product state plotted as a function of their energy. The three dFigure 12. (Color online) Figure reproduced from Ref. [12] showing the ⇡ in text (right). Bottom row: Entanglement entropy of all eigenstates for a symmetric bipartition of“enhancement” of the QMBS in the PXP model with the addition of a particular a function of their energy. The three data sets correspond to the same parameters as in the top row. perturbation. This result, among many others (e.g., those discussed in Refs. [132, 101]), sites in the zero momentum and inversion symmetric sector.hints towards a connection between examples of exact towers of QMBS discussed in this review and the approximate QMBS in the PXP model.

Stability of QMBS Another important question that requires further investigation is the stability of exact QMBS to perturbations. One aspect of stability is whether the QMBS eigenstates survive perturbations in the thermodynamic limit. Refs. [206] and [134] explored this question for the exact QMBS in the 1d PXP model [132] and the tower of QMBS in the spin-1 XY model [81], and found evidence that in the thermodynamic limit, QMBS are unstable to generic perturbations, i.e., they hybridize with thermal eigenstates for arbitrary small perturbation strengths. Nevertheless, the thermalization times for local observables in the perturbed model was found to be finite and parametrically large (i.e., diverging as the perturbation strength goes to zero) even in the thermodynamic limit [206], and the QMBS eigenstates displayed anomalous robustness at first order perturbation theory [134]. These results show that the exact QMBS in the PXP model do have some degree of stability under perturbations even in the thermodynamic limit, and it would be interesting to systematically probe this question for other examples of QMBS, particularly for exact towers discussed in Sec. 3.

Irrespective of their stability in the thermodynamic limit, a more experimentally relevant question in the current era of quantum simulators and Noisy Intermediate Scale Quantum (NISQ) devices [207] is the stability of QMBS signatures in finite-size systems. For example, we can ask whether signatures of QMBS such as anomalous dynamics on unexpectedly long time-scales persist under perturbations, or if for finite system sizes, approximate QMBS survive in models that are proximate to those with exact QMBS. A classic example is the PXP model, where approximate QMBS seem rather robust to perturbations [12, 191, 130, 131, 208], and experimentally show slowlydecaying revivals [7, 61]. These experimental setups consist of 51-200 Rydberg atoms, far from the thermodynamic limit, which motivates the study of the stability of QMBS at finite system-sizes. The QMBS in the PXP model have been studied using a wide variety of techniques that yield several insights into the origin of the approximate QMBS [13, 10, 128, 130, 131], and several phenomenological results are known about the PXP models, and their deformations [11, 12, 129, 209]. Nevertheless, a major open question in this field is to precisely connect these results on the approximate QMBS in the PXP to exact QMBS in various other systems. In particular, can these approximate QMBS be understood due to its proximity to a model with exact QMBS? Evidence supporting this was shown in Refs. [132, 133, 101], which found approximate momentum $\pi$ multi-quasiparticle descriptions of the PXP QMBS. Moreover, Ref. [11] found a Hamiltonian proximate to the PXP model that shows an atypical behavior of level statistics with system size, which they conjectured to be an integrable point. Later, Ref. [12] found a different Hamiltonian proximate to the PXP model that exhibits almost perfect revivals and a greatly enhanced decoupling of the QMBS subspace from the rest of the spectrum (see Fig. 12). These works reveal that the phenomenology of the approximate QMBS in the PXP model resembles that of exact towers of QMBS discussed in Sec. 3, and suggest that exact QMBS might have more stability than currently believed, at least for present-day experimentally accessible system-sizes.

Floquet QMBS The exploration of QMBS beyond Hamiltonian systems, for example in Floquet systems, is also an interesting direction of study. Exact QMBS in the PXP model [132] were extended to Floquet-PXP Hamiltonians in Ref. [210], and some of them were shown to be intrinsic to Floquet systems, arising only at particular drive frequencies [211]. A related result is the construction of exact eigenstates based on short orbits in a cellular automaton that is obtained in an appropriate limit of the Floquet-PXP Hamiltonian in Ref. [212]. Moreover, it should be possible to generalize some of unified formalisms, particularly the SM formalism to Floquet systems, which might lead to Floquet analogues of some of the QMBS discussed in this review. The exploration of QMBS in Floquet systems is particularly interesting since recent experimental and numerical results suggest that QMBS in the PXP model can be stabilized under periodic driving [61, 213]. Furthermore, obtaining more analytically tractable examples might shed light on the many numerical results on QMBS in driven

![](images/8e1d2da3b9ac614c885bc0fe384e1fced0350f5194c4dca7b2e4688ffe23d2c1.jpg)  
Figure 13. Schematic depiction of the block diagonal structure of the Hamiltonian showing the dynamically disconnected “Krylov subspaces” in systems with (a) conventional symmetries (b) Hilbert space fragmentation (c) QMBS.

systems [214, 215, 216, 217, 218, 219].

Fragmentation and symmetries Turning to Hilbert space fragmentation, several open questions are still looming. Firstly, the phenomenon of Hilbert space fragmentation clearly demonstrates the need to sharpen the definition of “symmetry” in a quantum many-body system [117]. The Krylov subspaces that occur in fragmented systems are strongly reminiscent of quantum number sectors of conventional symmetry, e.g., as shown in Fig. 13. Conserved quantities associated with conventional symmetries are typically sums of local terms, or products of on-site unitary operators, and the dynamically disconnected subspaces in such systems are the different eigenspaces of such quantities. However, in fragmented systems, the Krylov subspaces are labeled by the eigenvalues of certain non-local conserved quantities [168, 117], which could be considered as “non-local symmetries”; however, unlike non-local symmetries that appear in the literature (e.g., in the context of topological systems), these do not have obvious on-site actions. If arbitrary non-local operators are considered valid conserved quantities, any finite-dimensional Hamiltonian trivially has exponentially many conserved quantities – the eigenstate projectors; hence the necessity of a better definition, or a more practical and experimentally motivated one. This might also help settle debates [27, 26] about which symmetries/Krylov subspaces are needed to be resolved in order to test ETH. Understanding the precise nature of ETH-violation in fragmented systems is important, since restricted versions of ETH and MBL have been found to hold within sufficiently large Krylov subspaces, leading to notions of Krylov-Restricted Thermalization and its breakdown.

Analytical examples of fragmentation A different direction that needs to be pursued is the search for additional analytically tractable examples of fragmentation, which might also help better understand the necessary and sufficient conditions for fragmentation to occur. As discussed in Sec. 6.1, an experimentally relevant example that is well understood is the case with dipole moment conservation in one dimension. While a general characterization of all the Krylov subspaces was obtained in the minimalrange spin-1 dipole-conserving model in Ref. [117], a more general understanding of the longer-range dipole-conserving model apart from the minimal-range ones [19, 168, 117] is lacking, and many of the results, such as the nature of fragmentation (strong or weak), rely on numerical observations. The exploration of fragmentation in higher dimensions is also important, particularly since two-dimensional systems are sometimes easier to simulate using optical lattices. Multipole moment conservation laws can be imposed by subjecting systems to particular electric potentials, and while Ref. [18] showed that these are sufficient to guarantee fragmentation, several questions, such as the structure of larger Krylov subspaces, have not been explored. Hilbert space fragmentation might also be related to several earlier examples of ergodicity breaking due to the formation of dynamical subsectors, such as dynamical localization in gauge theories [220], or localization due to superselection sectors [221], and it would be interesting to make the connections more precise. On a different note, several aspects of fragmentation might be relevant in the study of equilibrium physics close to the ground state. For example, as a consequence of fragmentation, the ground state and some low-lying excited states of some dipole-conserving models that appear in the thin-torus limit of fractional Quantum Hall systems were found to have simple expressions in terms of fragmented Matrix Product States [222, 223], which proved useful in addressing questions on the gap of such systems [224, 225].

Classical versus Quantum fragmentation Finally, most examples of Hilbert space fragmentation consist of Hamiltonians that are fragmented in the product state basis (“classical fragmentation”), and the Krylov subspaces are completely determined by the transitions between product states allowed by terms of the Hamiltonian, which is essentially a classical process. The possibility of fragmentation in a more entangled basis (“quantum fragmentation”) was recently pointed out in the spin-1 biquadratic model [117], but the dynamics in such systems is relatively unexplored, and it remains to be understood whether such fragmentation leads to qualitatively new dynamical phenomena absent in simpler models. Exploring fragmentation and Krylov subspaces in different bases might also help distinguish between or establish a relation between QMBS discussed in Secs. 3 and 4 and the phenomenon of weak Hilbert space fragmentation, which share several common features. In particular, can towers of QMBS be understood in the same language as Hilbert space fragmentation, since the subspace spanned by the QMBS can be viewed as an small Krylov subspace within the full Hilbert space [131] (see Fig. 13)?

QMBS and Hilbert space fragmentation have already attracted a large attention thanks to their experimental realization in quantum simulators and the existence of an abundance of exact results and toy models, a rarity in the realm of strongly correlated quantum systems. However the number of open challenges that we have tried to expose here will undoubtedly be a source of rich discussions and physics, and guarantees a bright and exciting future for this field.

Note added — While this review was in preparation, Ref. [14] appeared, which provides a complementary pedagogical review of aspects of quantum many-body scars and Hilbert space fragmentation.

# Acknowledgments

We are particularly grateful to Lesik Motrunich for enlightening discussions. We also acknowledge useful discussions with Berislav Buca, Dumitru Calugaru, Paul Fendley, David Huse, Tom Iadecola, Frank Pollmann, and Pablo Sala. We thank Stephan Rachel, Abhinav Prem, Rahul Nandkishore, Ana Hudomal, Ivana Vasic, Zlatko Papic, Loic Herviou, Jens Bardarson, Edward O’Brien, Paul Fendley, and Lesik Motrunich for previous collaborations on related topics. We are grateful to Yichen Huang, Tom Iadecola, Igor Klebanov, Kiryl Pakrouski, Zlatko Papic, Fedor Popov, Frank Pollmann, Lesik Motrunich, Pablo Sala, and Lenart Zadnik for their comments and feedback on an earlier version of this review. This work is part of a project that has received funding from the European Research Council (ERC) under the European Union’s Horizon 2020 research and innovation programme (grant agreement no. 101020833). This work is supported by the Walter Burke Institute for Theoretical Physics at Caltech and the Institute for Quantum Information and Matter. S.M. acknowledges the hospitality of the Aspen Center for Physics, where a part of this work was completed. The Aspen Center for Physics is supported by National Science Foundation grant PHY-1607611. This work was also partially supported by a grant from the Simons Foundation.

# References

[1] Deutsch J M, 1991, Physical Review A 43(4) 2046–2049. [2] Srednicki M, 1994, Physical Review E 50(2) 888–901. [3] Nandkishore R and Huse D A, 2015, Annual Review of Condensed Matter Physics 6 15–38. [4] Abanin D A, Altman E, Bloch I and Serbyn M, 2019, Reviews of Modern Physics 91(2) 021001. [5] Suntajs J, Bonˇca J, Prosen T c v and Vidmar L, 2020, ˇ Phys. Rev. E 102(6) 062144. [6] Abanin D, Bardarson J, De Tomasi G, Gopalakrishnan S, Khemani V, Parameswaran S, Pollmann F, Potter A, Serbyn M and Vasseur R, 2021, Annals of Physics 427 168415. [7] Bernien H, Schwartz S, Keesling A, Levine H, Omran A, Pichler H, Choi S, Zibrov A S, Endres M, Greiner M, Vuleti´c V and Lukin M D, 2017, Nature 551 579–584. [8] Turner C, Michailidis A, Abanin D, Serbyn M and Papic Z, 2018, Nature Physics 14 745–749. [9] Turner C J, Michailidis A A, Abanin D A, Serbyn M and Papi´c Z, 2018, Phys. Rev. B 98(15) 155134. [10] Ho W W, Choi S, Pichler H and Lukin M D, 2019, Physical Review Letters 122(4) 040603. [11] Khemani V, Laumann C R and Chandran A, 2019, Physical Review B 99(16) 161101. [12] Choi S, Turner C J, Pichler H, Ho W W, Michailidis A A, Papi´c Z, Serbyn M, Lukin M D and Abanin D A, 2019, Physical Review Letters 122(22) 220603. [13] Serbyn M, Abanin D A and Papi´c Z, 2021, Nature Physics 17 675–685. [14] Papi´c Z, 2021, arXiv e-prints arXiv:2108.03460. [15] Moudgalya S, Rachel S, Bernevig B A and Regnault N, 2018, Physical Review B 98(23) 235155. [16] Affleck I, Kennedy T, Lieb E H and Tasaki H, 1987, Physical Review Letters 59 799–802. [17] Sala P, Rakovszky T, Verresen R, Knap M and Pollmann F, 2020, Phys. Rev. X 10(1) 011047. [18] Khemani V, Hermele M and Nandkishore R, 2020, Phys. Rev. B 101(17) 174204.

[19] Moudgalya S, Prem A, Nandkishore R, Regnault N and Bernevig B A, 2021, Memorial Volume for Shoucheng Zhang chap 7, pp 147–209 URL https://www.worldscientific.com/doi/abs/ 10.1142/9789811231711_0009   
[20] Zadnik L and Fagotti M, 2021, SciPost Phys. Core 4(2) 10.   
[21] Polkovnikov A, Sengupta K, Silva A and Vengalattore M, 2011, Reviews of Modern Physics 83(3) 863–883.   
[22] D’Alessio L, Kafri Y, Polkovnikov A and Rigol M, 2016, Advances in Physics 65 239–362. [23] Rigol M, Dunjko V and Olshanii M, 2008, Nature 452 854–858.   
[24] Beugeling W, Moessner R and Haque M, 2014, Physical Review E 89(4) 042112.   
[25] Huang Y, 2022, Annals of Physics 168761.   
[26] Shiraishi N and Mori T, 2018, Phys. Rev. Lett. 121(3) 038902.   
[27] Mondaini R, Mallayya K, Santos L F and Rigol M, 2018, Phys. Rev. Lett. 121(3) 038901. [28] Kim H, Ikeda T N and Huse D A, 2014, Physical Review E 90(5) 052105.   
[29] Garrison J R and Grover T, 2018, Physical Review X 8(2) 021026.   
[30] St¨ockmann H J, 2000, American Journal of Physics 68 777–778.   
[31] Bohigas O, Giannoni M J and Schmit C, 1984, Phys. Rev. Lett. 52(1) 1–4.   
[32] Br´ezin E and Hikami S, 1997, Phys. Rev. E 55(4) 4067–4083.   
[33] Dyson F J, 1962, Journal of Mathematical Physics 3 1191–1198.   
[34] Poilblanc D, Ziman T, Bellissard J, Mila F and Montambaux G, 1993, Europhysics Letters (EPL) 22 537–542.   
[35] Giraud O, Mac´e N, Vernier E and Alet F, 2022, Phys. Rev. X 12(1) 011006.   
[36] Oganesyan V and Huse D A, 2007, Phys. Rev. B 75(15) 155111.   
[37] Atas Y Y, Bogomolny E, Giraud O and Roux G, 2013, Physical Review Letters 110 084101. [38] Eisert J, Cramer M and Plenio M B, 2010, Reviews of Modern Physics 82(1) 277–306. [39] Nishioka T, Ryu S and Takayanagi T, 2009, Journal of Physics A: Mathematical and Theoretical 42 504008.   
[40] Calabrese P and Cardy J, 2009, Journal of Physics A: Mathematical and Theoretical 42 504005. [41] Page D N, 1993, Physical Review Letters 71(9) 1291–1294.   
[42] Morampudi S C, Chandran A and Laumann C R, 2020, Phys. Rev. Lett. 124(5) 050602. [43] Schollw¨ock U, 2011, Annals of Physics 326 96 – 192 january 2011 Special Issue.   
[44] Verstraete F, Murg V and Cirac J I, 2008, Advances in Physics 57 143–224.   
[45] Orus R, 2014, Annals of Physics 349 117 – 158.   
[46] Perez-Garcia D, Verstraete F, Wolf M M and Cirac J I, 2007, Quantum Info. Comput. 7 401–430. [47] Hastings M B, 2007, Journal of Statistical Mechanics: Theory and Experiment 2007 P08024– P08024.   
[48] Kitaev A, 2003, Annals of Physics 303 2–30.   
[49] Kitaev A and Laumann C, 2010, Exact Methods in Low-dimensional Statistical Physics and Quantum Computing: Lecture Notes of the Les Houches Summer School: Volume 89, July 2008 101.   
[50] Faddeev L D, 1996, arXiv e-prints hep-th/9605187.   
[51] De Roeck W and Huveneers F m c, 2017, Phys. Rev. B 95(15) 155129.   
[52] Sels D and Polkovnikov A, 2021, Phys. Rev. E 104(5) 054105 arXiv:2009.04501.   
[53] Crowley P J D and Chandran A, 2020, arXiv e-prints arXiv:2012.14393.   
[54] Huse D A, Nandkishore R and Oganesyan V, 2014, Phys. Rev. B 90(17) 174202.   
[55] Alba V, Fagotti M and Calabrese P, 2009, Journal of Statistical Mechanics: Theory and Experiment 2009 P10020.   
[56] Vidmar L, Hackl L, Bianchi E and Rigol M, 2017, Phys. Rev. Lett. 119(2) 020601.   
[57] Alba V, 2015, Phys. Rev. B 91(15) 155123.   
[58] Khemani V, Chandran A, Kim H and Sondhi S L, 2014, Phys. Rev. E 90(5) 052133.   
[59] Heller E J, 1984, Physical Review Letters 53(16) 1515–1518.   
[60] B¨acker A, 2003, Numerical aspects of eigenvalue and eigenfunction computations for chaotic

quantum systems The Mathematical Aspects of Quantum Maps ed Esposti M D and Graffi S (Berlin, Heidelberg: Springer Berlin Heidelberg) pp 91–144 [61] Bluvstein D, Omran A, Levine H, Keesling A, Semeghini G, Ebadi S, Wang T T, Michailidis A A, Maskara N, Ho W W, Choi S, Serbyn M, Greiner M, Vuleti´c V and Lukin M D, 2021, Science 371 1355–1359. [62] Herviou L, Bardarson J H and Regnault N, 2021, Phys. Rev. B 103(13) 134207. [63] Alhambra A M, Anshu A and Wilming H, 2020, Phys. Rev. B 101(20) 205107. [64] Moudgalya S, Regnault N and Bernevig B A, 2018, Physical Review B 98(23) 235156. [65] Arovas D P, Auerbach A and Haldane F D M, 1988, Phys. Rev. Lett. 60(6) 531–534. [66] Arovas D P, 1989, Physics Letters A 137 431 – 433. [67] Iadecola T and Znidariˇc M, 2019, ˇ Phys. Rev. Lett. 123(3) 036403. [68] Yang C N, 1989, Physical Review letters 63 2144. [69] Yang C N and Zhang S, 1990, Modern Physics Letters B 4 759–766. [70] Essler F H, Frahm H, G¨ohmann F, Kl¨umper A and Korepin V E, 2005, The one-dimensional Hubbard model (Cambridge University Press) [71] Barut A O and B¨ohm A, 1965, Phys. Rev. 139(4B) B1107–B1112. [72] Dothan Y, Gell-Mann M and Ne’eman Y, 1965, Physics Letters 17 148 – 151. [73] Buˇca B, Tindall J and Jaksch D, 2019, Nature Communications 10 1730. [74] Medenjak M, Buˇca B and Jaksch D, 2020, Phys. Rev. B 102(4) 041117. [75] Vafek O, Regnault N and Bernevig B A, 2017, SciPost Phys. 3(6) 043. [76] Moudgalya S, Regnault N and Bernevig B A, 2020, Phys. Rev. B 102(8) 085140. [77] Mark D K and Motrunich O I, 2020, Phys. Rev. B 102(7) 075132. [78] Dzyaloshinsky I, 1958, Journal of Physics and Chemistry of Solids 4 241–255. [79] Moriya T, 1960, Phys. Rev. 120(1) 91–98. [80] Dooley S, 2021, PRX Quantum 2(2) 020330. [81] Schecter M and Iadecola T, 2019, Phys. Rev. Lett. 123(14) 147201. [82] Iadecola T and Schecter M, 2020, Phys. Rev. B 101(2) 024306. [83] O’Dea N, Burnell F, Chandran A and Khemani V, 2020, Phys. Rev. Research 2(4) 043305. [84] Moudgalya S, O’Brien E, Bernevig B A, Fendley P and Regnault N, 2020, Phys. Rev. B 102(8) 085120. [85] Mark D K, Lin C J and Motrunich O I, 2020, Phys. Rev. B 101(19) 195131. [86] Chattopadhyay S, Pichler H, Lukin M D and Ho W W, 2020, Physical Review B 101(17) 174308. [87] Shibata N, Yoshioka N and Katsura H, 2020, Phys. Rev. Lett. 124(18) 180604. [88] van Voorden B, Marcuzzi M, Schoutens K and Min´aˇr J, 2021, Phys. Rev. B 103(22) L220301. [89] Hudomal A, Vasi´c I, Regnault N and Papi´c Z, 2020, Communications Physics 3 99. [90] Lee K, Melendrez R, Pal A and Changlani H J, 2020, Phys. Rev. B 101(24) 241111. [91] Hart O, De Tomasi G and Castelnovo C, 2020, Phys. Rev. Research 2(4) 043267. [92] Chertkov E and Clark B K, 2021, Phys. Rev. B 104(10) 104410. [93] Langlett C M, Yang Z C, Wildeboer J, Gorshkov A V, Iadecola T and Xu S, 2022, Phys. Rev. B 105(6) L060301. [94] Zhao H, Smith A, Mintert F and Knolle J, 2021, Phys. Rev. Lett. 127(15) 150601. [95] Pirvu B, Murg V, Cirac J I and Verstraete F, 2010, New Journal of Physics 12 025012. [96] McCulloch I P, 2007, Journal of Statistical Mechanics: Theory and Experiment 2007 P10014. [97] Crosswhite G M and Bacon D, 2008, Phys. Rev. A 78(1) 012356. [98] Motruk J, Zaletel M P, Mong R S K and Pollmann F, 2016, Phys. Rev. B 93(15) 155139. [99] Castro-Alvaredo O A, De Fazio C, Doyon B and Sz´ecs´enyi I M, 2018, Phys. Rev. Lett. 121(17) 170602. [100] Ren J, Liang C and Fang C, 2022, Phys. Rev. Research 4(1) 013155. [101] Iadecola T, Schecter M and Xu S, 2019, Physical Review B 100(18) 184312. [102] Lesanovsky I, 2011, Physical Review Letters 106 025301. [103] Shiraishi N and Mori T, 2017, Phys. Rev. Lett. 119(3) 030601.

[105] Ren J, Liang C and Fang C, 2021, Phys. Rev. Lett. 126(12) 120604.   
[106] Tang L H, O’Dea N and Chandran A, 2021, arXiv e-prints arXiv:2110.11448.   
[107] Pakrouski K, Pallegar P N, Popov F K and Klebanov I R, 2021, Phys. Rev. Research 3(4) 043156.   
[108] Ok S, Choo K, Mudry C, Castelnovo C, Chamon C and Neupert T, 2019, Phys. Rev. Research 1(3) 033144.   
[109] Majumdar C K and Ghosh D K, 1969, Journal of Mathematical Physics 10 1388–1398.   
[110] Qi X L and Ranard D, 2019, Quantum 3 159.   
[111] Chertkov E and Clark B K, 2018, Phys. Rev. X 8(3) 031029.   
[112] Srivatsa N S, Wildeboer J, Seidel A and Nielsen A E B, 2020, Phys. Rev. B 102(23) 235106.   
[113] Jeyaretnam J, Richter J and Pal A, 2021, Phys. Rev. B 104(1) 014424.   
[114] McClarty P A, Haque M, Sen A and Richter J, 2020, Phys. Rev. B 102(22) 224303.   
[115] Surace F M, Giudici G and Dalmonte M, 2020, Quantum 4 339.   
[116] Banerjee D and Sen A, 2021, Phys. Rev. Lett. 126(22) 220601.   
[117] Moudgalya S and Motrunich O I, 2022, Phys. Rev. X 12(1) 011050 arXiv:2108.10324.   
[118] Lesanovsky I and Katsura H, 2012, Phys. Rev. A 86(4) 041601.   
[119] Schecter M and Iadecola T, 2018, Phys. Rev. B 98(3) 035139.   
[120] Moudgalya S, Bernevig B A and Regnault N, 2020, Phys. Rev. B 102(19) 195150.   
[121] Trebst S, Troyer M, Wang Z and Ludwig A W W, 2008, Progress of Theoretical Physics Supplement 176 384–407.   
[122] Chandran A, Burnell F J and Sondhi S L, 2020, Phys. Rev. B 101(7) 075104.   
[123] Moessner R and Sondhi S L, 2001, Phys. Rev. B 63(22) 224401.   
[124] Laumann C R, Moessner R, Scardicchio A and Sondhi S L, 2012, Phys. Rev. Lett. 109(3) 030502.   
[125] Surace F M, Mazza P P, Giudici G, Lerose A, Gambassi A and Dalmonte M, 2020, Phys. Rev.   
$X$ 10(2) 021041.   
[126] Chen I C and Iadecola T, 2021, Phys. Rev. B 103(21) 214304.   
[127] Fendley P, Sengupta K and Sachdev S, 2004, Phys. Rev. B 69(7) 075106.   
[128] Michailidis A A, Turner C J, Papi´c Z, Abanin D A and Serbyn M, 2020, Phys. Rev. X 10(1) 011055.   
[129] Bull K, Martin I and Papi´c Z, 2019, Phys. Rev. Lett. 123(3) 030601.   
[130] Turner C J, Desaules J Y, Bull K and Papi´c Z, 2021, Phys. Rev. X 11(2) 021021.   
[131] Bull K, Desaules J Y and Papi´c Z, 2020, Phys. Rev. B 101(16) 165139.   
[132] Lin C J and Motrunich O I, 2019, Phys. Rev. Lett. 122(17) 173401.   
[133] Mark D K, Lin C J and Motrunich O I, 2020, Physical Review B 101(9) 094308.   
[134] Surace F M, Votto M, Lazo E G, Silva A, Dalmonte M and Giudici G, 2021, Phys. Rev. B 103(10) 104302.   
[135] Karle V, Serbyn M and Michailidis A A, 2021, Phys. Rev. Lett. 127(6) 060602.   
[136] Shiraishi N, 2019, Journal of Statistical Mechanics: Theory and Experiment 2019 083103.   
[137] Lin C J, Calvera V and Hsieh T H, 2020, Phys. Rev. B 101(22) 220304.   
[138] Michailidis A A, Turner C J, Papi´c Z, Abanin D A and Serbyn M, 2020, Phys. Rev. Research 2(2) 022065.   
[139] Pizorn I, 2012, arXiv e-prints arXiv:1202.3336.   
[140] Caspers W and Magnus W, 1982, Physics Letters A 88 103–105.   
[141] Caspers W, Emmett K and Magnus W, 1984, Journal of Physics A: Mathematical and General 17 2687.   
[142] Bibikov P, 2018, Journal of Statistical Mechanics: Theory and Experiment 2018 043108.   
[143] Ren J H, Ye M Y and Lin X M, 2018, Chinese Phys. B 27 073102.   
[144] Ye M Y and Lin X M, 2018, physica status solidi (b) 255 1700321.   
[145] Pai S, Pretko M and Nandkishore R M, 2019, Phys. Rev. X 9(2) 021003.   
[146] Ritort F and Sollich P, 2003, Advances in Physics 52 219–342. [147] Bergholtz E J and Karlhede A, 2005, Physical Review Letters 94 026802.   
[148] Bergholtz E J and Karlhede A, 2006, Journal of Statistical Mechanics: Theory and Experiment 2006 L04001.   
[149] Olmos B, M¨uller M and Lesanovsky I, 2010, New Journal of Physics 12 013024.   
[150] Sikora O, Shannon N, Pollmann F, Penc K and Fulde P, 2011, Phys. Rev. B 84(11) 115129.   
[151] Nakamura M, Wang Z Y and Bergholtz E J, 2012, Physical Review Letters 109(1) 016401.   
[152] Gopalakrishnan S and Zakirov B, 2018, Quantum Science and Technology 3 044004.   
[153] Lan Z, van Horssen M, Powell S and Garrahan J P, 2018, Phys. Rev. Lett. 121(4) 040603.   
[154] Seidel A, Fu H, Lee D H, Leinaas J M and Moore J, 2005, Phys. Rev. Lett. 95(26) 266405.   
[155] Bergholtz E J and Karlhede A, 2008, Phys. Rev. B 77(15) 155308.   
[156] Lee C H, Papi´c Z and Thomale R, 2015, Phys. Rev. X 5(4) 041003.   
[157] Papi´c Z, 2014, Phys. Rev. B 90(7) 075304.   
[158] Rezayi E H and Haldane F D M, 1994, Phys. Rev. B 50(23) 17199–17207.   
[159] van Nieuwenburg E, Baum Y and Refael G, 2019, Proceedings of the National Academy of Sciences 116 9269–9274.   
[160] Schulz M, Hooley C A, Moessner R and Pollmann F, 2019, Phys. Rev. Lett. 122(4) 040606.   
[161] Taylor S R, Schulz M, Pollmann F and Moessner R, 2020, Phys. Rev. B 102(5) 054206.   
[162] Guardado-Sanchez E, Morningstar A, Spar B M, Brown P T, Huse D A and Bakr W S, 2020, Phys. Rev. X 10(1) 011042.   
[163] Scherg S, Kohlert T, Sala P, Pollmann F, Hebbe Madhusudhana B, Bloch I and Aidelsburger M, 2021, Nature Communications 12 4490.   
[164] Kohlert T, Scherg S, Sala P, Pollmann F, Hebbe Madhusudhana B, Bloch I and Aidelsburger M, 2021, arXiv e-prints arXiv:2106.15586.   
[165] Doggen E V H, Gornyi I V and Polyakov D G, 2021, Phys. Rev. B 103(10) L100202.   
[166] Lieb E H and Liniger W, 1963, Physical Review 130(4) 1605–1616.   
[167] Morningstar A, Khemani V and Huse D A, 2020, Phys. Rev. B 101(21) 214205.   
[168] Rakovszky T, Sala P, Verresen R, Knap M and Pollmann F, 2020, Phys. Rev. B 101(12) 125126.   
[169] Zhang S, Karbach M, M¨uller G and Stolze J, 1997, Phys. Rev. B 55(10) 6491–6503.   
[170] Batista C D and Ortiz G, 2000, Phys. Rev. Lett. 85(22) 4755–4758.   
[171] Bravyi S, DiVincenzo D P and Loss D, 2011, Annals of Physics 326 2793–2826.   
[172] De Tomasi G, Hetterich D, Sala P and Pollmann F, 2019, Phys. Rev. B 100(21) 214313.   
[173] Yang Z C, Liu F, Gorshkov A V and Iadecola T, 2020, Phys. Rev. Lett. 124(20) 207602.   
[174] Bastianello A, Borla U and Moroz S, 2022, Phys. Rev. Lett. 128(19) 196601.   
[175] Mukherjee B, Banerjee D, Sengupta K and Sen A, 2021, Phys. Rev. B 104(15) 155117.   
[176] Mukherjee B, Cai Z and Liu W V, 2021, Phys. Rev. Research 3(3) 033201.   
[177] Lee K, Pal A and Changlani H J, 2021, Phys. Rev. B 103(23) 235133.   
[178] Hahn D, McClarty P A and Luitz D J, 2021, SciPost Phys. 11(4) 74.   
[179] Li W H, Deng X and Santos L, 2021, Phys. Rev. Lett. 127(26) 260601.   
[180] Langlett C M and Xu S, 2021, Phys. Rev. B 103(22) L220304.   
[181] Richter J and Pal A, 2022, Phys. Rev. Research 4(1) L012003.   
[182] Zadnik L, Bidzhiev K and Fagotti M, 2021, SciPost Phys. 10(5) 99.   
[183] Pozsgay B, Gombor T, Hutsalyuk A, Jiang Y, Pristy´ak L and Vernier E, 2021, Phys. Rev. E 104(4) 044106.   
[184] Bidzhiev K, Fagotti M and Zadnik L, 2022, Phys. Rev. Lett. 128(13) 130603.   
[185] Read N and Saleur H, 2007, Nuclear Physics B 777 263 – 315.   
[186] Khudorozhkov A, Tiwari A, Chamon C and Neupert T, 2021, arXiv e-prints arXiv:2107.09690.   
[187] De Tomasi G and Khaymovich I M, 2020, Phys. Rev. Lett. 124(20) 200602.   
[188] Desaules J Y, Hudomal A, Turner C J and Papi´c Z, 2021, Phys. Rev. Lett. 126(21) 210601.   
[189] Feng X and Skinner B, 2022, Phys. Rev. Research 4(1) 013053.   
[190] Chen C, Burnell F and Chandran A, 2018, Phys. Rev. Lett. 121(8) 085701.   
[191] Mondragon-Shem I, Vavilov M G and Martin I, 2021, PRX Quantum 2(3) 030349 arXiv:2010.

10535. [192] Fendley P, 2012, Journal of Statistical Mechanics: Theory and Experiment 2012 P11020. [193] Fendley P, 2016, Journal of Physics A: Mathematical and Theoretical 49 30LT01. [194] Alicea J and Fendley P, 2016, Annual Review of Condensed Matter Physics 7 119–139. [195] Feldmeier J, Pollmann F and Knap M, 2021, Phys. Rev. B 103(9) 094303. [196] Buˇca B, 2022, Phys. Rev. Lett. 128(10) 100601. [197] Mazur P, 1969, Physica 43 533 – 545. [198] Suzuki M, 1971, Physica 51 277 – 291. [199] Dhar A, Kundu A and Saito K, 2021, Chaos, Solitons & Fractals 144 110618. [200] Feldmeier J, Sala P, De Tomasi G, Pollmann F and Knap M, 2020, Phys. Rev. Lett. 125(24) 245303. [201] Iaconis J, Vijay S and Nandkishore R, 2019, Phys. Rev. B 100(21) 214301. [202] Iaconis J, Lucas A and Nandkishore R, 2021, Phys. Rev. E 103(2) 022142. [203] Moudgalya S, Prem A, Huse D A and Chan A, 2021, Phys. Rev. Research 3(2) 023176. [204] Zhang P, 2020, Phys. Rev. Research 2(3) 033129. [205] Feldmeier J and Knap M, 2021, Phys. Rev. Lett. 127(23) 235301. [206] Lin C J, Chandran A and Motrunich O I, 2020, Phys. Rev. Research 2(3) 033044. [207] Preskill J, 2018, Quantum 2 79. [208] Surace F M, Dalmonte M and Silva A, 2021, arXiv e-prints arXiv:2107.00884. [209] Yao Z, Pan L, Liu S and Zhai H, 2022, Phys. Rev. B 105(12) 125123. [210] Mizuta K, Takasan K and Kawakami N, 2020, Phys. Rev. Research 2(3) 033284. [211] Sugiura S, Kuwahara T and Saito K, 2021, Phys. Rev. Research 3(1) L012010. [212] Iadecola T and Vijay S, 2020, Phys. Rev. B 102(18) 180302. [213] Maskara N, Michailidis A A, Ho W W, Bluvstein D, Choi S, Lukin M D and Serbyn M, 2021, Phys. Rev. Lett. 127(9) 090602. [214] Pai S and Pretko M, 2019, Phys. Rev. Lett. 123(13) 136401. [215] Mukherjee B, Nandy S, Sen A, Sen D and Sengupta K, 2020, Phys. Rev. B 101(24) 245107. [216] Pizzi A, Malz D, De Tomasi G, Knolle J and Nunnenkamp A, 2020, Phys. Rev. B 102(21) 214207. [217] Yarloo H, Emami Kopaei A and Langari A, 2020, Phys. Rev. B 102(22) 224309. [218] Zhao H, Vovrosh J, Mintert F and Knolle J, 2020, Phys. Rev. Lett. 124(16) 160604. [219] Haldar A, Sen D, Moessner R and Das A, 2021, Phys. Rev. X 11(2) 021008. [220] Smith A, Knolle J, Moessner R and Kovrizhin D L, 2018, Phys. Rev. B 97(24) 245137. [221] Kim I H and Haah J, 2016, Phys. Rev. Lett. 116(2) 027202. [222] Nachtergaele B, Warzel S and Young A, 2020, Journal of Physics A: Mathematical and Theoretical 54 01LT01. [223] Nachtergaele B, Warzel S and Young A, 2021, Communications in Mathematical Physics 383 1093–1149. [224] Warzel S and Young A, 2021, arXiv e-prints arXiv:2108.10794. [225] Warze1 S and Young A, 2022, Journal of Mathematical Physics 63 041901.